/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.view.View;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.AnimatedNodeWithUpdateableConfig;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.PropsAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.views.view.ColorUtil;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/facebook/react/animated/ColorAnimatedNode;", "Lcom/facebook/react/animated/AnimatedNode;", "Lcom/facebook/react/animated/AnimatedNodeWithUpdateableConfig;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "nativeAnimatedNodesManager", "Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "reactApplicationContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReadableMap;Lcom/facebook/react/animated/NativeAnimatedNodesManager;Lcom/facebook/react/bridge/ReactApplicationContext;)V", "aNodeId", "", "bNodeId", "color", "getColor", "()I", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "gNodeId", "nativeColor", "nativeColorApplied", "", "rNodeId", "onUpdateConfig", "", "prettyPrint", "", "tryApplyNativeColor", "Companion", "ReactAndroid_release"})
public final class ColorAnimatedNode
extends AnimatedNode
implements AnimatedNodeWithUpdateableConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NativeAnimatedNodesManager nativeAnimatedNodesManager;
    @NotNull
    private final ReactApplicationContext reactApplicationContext;
    private int rNodeId;
    private int gNodeId;
    private int bNodeId;
    private int aNodeId;
    @Nullable
    private ReadableMap nativeColor;
    private boolean nativeColorApplied;

    public ColorAnimatedNode(@NotNull ReadableMap config, @NotNull NativeAnimatedNodesManager nativeAnimatedNodesManager, @NotNull ReactApplicationContext reactApplicationContext) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)nativeAnimatedNodesManager, (String)"nativeAnimatedNodesManager");
        Intrinsics.checkNotNullParameter((Object)((Object)reactApplicationContext), (String)"reactApplicationContext");
        this.nativeAnimatedNodesManager = nativeAnimatedNodesManager;
        this.reactApplicationContext = reactApplicationContext;
        this.onUpdateConfig(config);
    }

    public final int getColor() {
        this.tryApplyNativeColor();
        ValueAnimatedNode rNode = (ValueAnimatedNode)this.nativeAnimatedNodesManager.getNodeById(this.rNodeId);
        ValueAnimatedNode gNode = (ValueAnimatedNode)this.nativeAnimatedNodesManager.getNodeById(this.gNodeId);
        ValueAnimatedNode bNode = (ValueAnimatedNode)this.nativeAnimatedNodesManager.getNodeById(this.bNodeId);
        ValueAnimatedNode aNode = (ValueAnimatedNode)this.nativeAnimatedNodesManager.getNodeById(this.aNodeId);
        ValueAnimatedNode valueAnimatedNode = rNode;
        double r = valueAnimatedNode != null ? valueAnimatedNode.nodeValue : 0.0;
        ValueAnimatedNode valueAnimatedNode2 = gNode;
        double g = valueAnimatedNode2 != null ? valueAnimatedNode2.nodeValue : 0.0;
        ValueAnimatedNode valueAnimatedNode3 = bNode;
        double b = valueAnimatedNode3 != null ? valueAnimatedNode3.nodeValue : 0.0;
        ValueAnimatedNode valueAnimatedNode4 = aNode;
        double a = valueAnimatedNode4 != null ? valueAnimatedNode4.nodeValue : 0.0;
        return ColorUtil.normalize(r, g, b, a);
    }

    @Override
    public void onUpdateConfig(@Nullable ReadableMap config) {
        if (config != null) {
            this.rNodeId = config.getInt("r");
            this.gNodeId = config.getInt("g");
            this.bNodeId = config.getInt("b");
            this.aNodeId = config.getInt("a");
            this.nativeColor = config.getMap("nativeColor");
            this.nativeColorApplied = false;
            this.tryApplyNativeColor();
        } else {
            this.rNodeId = 0;
            this.gNodeId = 0;
            this.bNodeId = 0;
            this.aNodeId = 0;
            this.nativeColor = null;
            this.nativeColorApplied = false;
        }
    }

    @Override
    @NotNull
    public String prettyPrint() {
        return "ColorAnimatedNode[" + this.tag + "]: r: " + this.rNodeId + "  g: " + this.gNodeId + " b: " + this.bNodeId + " a: " + this.aNodeId;
    }

    private final void tryApplyNativeColor() {
        if (this.nativeColor == null || this.nativeColorApplied) {
            return;
        }
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        Context context2 = context;
        Integer color = ColorPropConverter.getColor(this.nativeColor, context2);
        ValueAnimatedNode rNode = (ValueAnimatedNode)this.nativeAnimatedNodesManager.getNodeById(this.rNodeId);
        ValueAnimatedNode gNode = (ValueAnimatedNode)this.nativeAnimatedNodesManager.getNodeById(this.gNodeId);
        ValueAnimatedNode bNode = (ValueAnimatedNode)this.nativeAnimatedNodesManager.getNodeById(this.bNodeId);
        ValueAnimatedNode aNode = (ValueAnimatedNode)this.nativeAnimatedNodesManager.getNodeById(this.aNodeId);
        if (rNode != null) {
            Intrinsics.checkNotNull((Object)color);
            rNode.nodeValue = Color.red((int)color);
        }
        if (gNode != null) {
            Intrinsics.checkNotNull((Object)color);
            gNode.nodeValue = Color.green((int)color);
        }
        if (bNode != null) {
            Intrinsics.checkNotNull((Object)color);
            bNode.nodeValue = Color.blue((int)color);
        }
        if (aNode != null) {
            Intrinsics.checkNotNull((Object)color);
            aNode.nodeValue = (double)Color.alpha((int)color) / 255.0;
        }
        this.nativeColorApplied = true;
    }

    private final Context getContext() {
        Activity activity = this.reactApplicationContext.getCurrentActivity();
        return activity != null ? (Context)activity : ColorAnimatedNode.Companion.getContextHelper(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/animated/ColorAnimatedNode$Companion;", "", "()V", "getContextHelper", "Landroid/content/Context;", "node", "Lcom/facebook/react/animated/AnimatedNode;", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Context getContextHelper(AnimatedNode node) {
            List<AnimatedNode> list = node.children;
            if (list != null) {
                List<AnimatedNode> children = list;
                boolean bl = false;
                Iterator<AnimatedNode> iterator2 = children.iterator();
                if (iterator2.hasNext()) {
                    Object object;
                    AnimatedNode child = iterator2.next();
                    if (child instanceof PropsAnimatedNode) {
                        View view;
                        View view2 = view = ((PropsAnimatedNode)child).getConnectedView();
                        object = view2 != null ? view2.getContext() : null;
                    } else {
                        object = Companion.getContextHelper(child);
                    }
                    return object;
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

