/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.style;

import android.graphics.LinearGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/react/uimanager/style/Gradient;", "", "gradient", "Lcom/facebook/react/bridge/ReadableMap;", "(Lcom/facebook/react/bridge/ReadableMap;)V", "colors", "", "endX", "", "endY", "positions", "", "startX", "startY", "type", "Lcom/facebook/react/uimanager/style/Gradient$GradientType;", "getShader", "Landroid/graphics/Shader;", "bounds", "Landroid/graphics/Rect;", "GradientType", "ReactAndroid_debug"})
public final class Gradient {
    @NotNull
    private final GradientType type;
    private float startX;
    private float startY;
    private float endX;
    private float endY;
    @NotNull
    private final int[] colors;
    @NotNull
    private final float[] positions;

    public Gradient(@Nullable ReadableMap gradient) {
        if (gradient == null) {
            throw new IllegalArgumentException("Gradient cannot be null");
        }
        String typeString = gradient.getString("type");
        if (!Intrinsics.areEqual((Object)typeString, (Object)"linearGradient")) {
            throw new IllegalArgumentException("Unsupported gradient type: " + typeString);
        }
        this.type = GradientType.LINEAR_GRADIENT;
        ReadableMap readableMap = gradient.getMap("start");
        if (readableMap != null) {
            ReadableMap start = readableMap;
            boolean bl = false;
            this.startX = (float)start.getDouble("x");
            this.startY = (float)start.getDouble("y");
        }
        ReadableMap readableMap2 = gradient.getMap("end");
        if (readableMap2 != null) {
            ReadableMap end = readableMap2;
            boolean bl = false;
            this.endX = (float)end.getDouble("x");
            this.endY = (float)end.getDouble("y");
        }
        ReadableArray readableArray = gradient.getArray("colorStops");
        if (readableArray == null) {
            throw new IllegalArgumentException("Invalid colorStops array");
        }
        ReadableArray colorStops = readableArray;
        int size = colorStops.size();
        this.colors = new int[size];
        this.positions = new float[size];
        for (int i = 0; i < size; ++i) {
            ReadableMap colorStop = colorStops.getMap(i);
            this.colors[i] = colorStop.getInt("color");
            this.positions[i] = (float)colorStop.getDouble("position");
        }
    }

    @Nullable
    public final Shader getShader(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        if (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()] != 1) {
            throw new NoWhenBranchMatchedException();
        }
        return (Shader)new LinearGradient(this.startX * (float)bounds.width(), this.startY * (float)bounds.height(), this.endX * (float)bounds.width(), this.endY * (float)bounds.height(), this.colors, this.positions, Shader.TileMode.CLAMP);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003\u00a8\u0006\u0004"}, d2={"Lcom/facebook/react/uimanager/style/Gradient$GradientType;", "", "(Ljava/lang/String;I)V", "LINEAR_GRADIENT", "ReactAndroid_debug"})
    private static final class GradientType
    extends Enum<GradientType> {
        public static final /* enum */ GradientType LINEAR_GRADIENT = new GradientType();
        private static final /* synthetic */ GradientType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static GradientType[] values() {
            return (GradientType[])$VALUES.clone();
        }

        public static GradientType valueOf(String value) {
            return Enum.valueOf(GradientType.class, value);
        }

        @NotNull
        public static EnumEntries<GradientType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = gradientTypeArray = new GradientType[]{GradientType.LINEAR_GRADIENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GradientType.values().length];
            try {
                nArray[GradientType.LINEAR_GRADIENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

