/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.style.CornerRadii;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u0004H\u00c2\u0003J\t\u0010\u000b\u001a\u00020\u0006H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/react/uimanager/LengthPercentage;", "", "()V", "value", "", "type", "Lcom/facebook/react/uimanager/LengthPercentageType;", "(FLcom/facebook/react/uimanager/LengthPercentageType;)V", "getType", "()Lcom/facebook/react/uimanager/LengthPercentageType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "resolve", "Lcom/facebook/react/uimanager/style/CornerRadii;", "width", "height", "toString", "", "Companion", "ReactAndroid_debug"})
public final class LengthPercentage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float value;
    @NotNull
    private final LengthPercentageType type;

    public LengthPercentage(float value, @NotNull LengthPercentageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.value = value;
        this.type = type;
    }

    @NotNull
    public final LengthPercentageType getType() {
        return this.type;
    }

    @NotNull
    public final CornerRadii resolve(float width, float height) {
        if (this.type == LengthPercentageType.PERCENT) {
            return new CornerRadii(this.value / (float)100 * width, this.value / (float)100 * height);
        }
        return new CornerRadii(this.value, this.value);
    }

    public LengthPercentage() {
        this(0.0f, LengthPercentageType.POINT);
    }

    private final float component1() {
        return this.value;
    }

    @NotNull
    public final LengthPercentageType component2() {
        return this.type;
    }

    @NotNull
    public final LengthPercentage copy(float value, @NotNull LengthPercentageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return new LengthPercentage(value, type);
    }

    public static /* synthetic */ LengthPercentage copy$default(LengthPercentage lengthPercentage, float f, LengthPercentageType lengthPercentageType, int n, Object object) {
        if ((n & 1) != 0) {
            f = lengthPercentage.value;
        }
        if ((n & 2) != 0) {
            lengthPercentageType = lengthPercentage.type;
        }
        return lengthPercentage.copy(f, lengthPercentageType);
    }

    @NotNull
    public String toString() {
        return "LengthPercentage(value=" + this.value + ", type=" + this.type + ")";
    }

    public int hashCode() {
        int result = Float.hashCode(this.value);
        result = result * 31 + this.type.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LengthPercentage)) {
            return false;
        }
        LengthPercentage lengthPercentage = (LengthPercentage)other;
        if (Float.compare(this.value, lengthPercentage.value) != 0) {
            return false;
        }
        return this.type == lengthPercentage.type;
    }

    @JvmStatic
    @Nullable
    public static final LengthPercentage setFromDynamic(@NotNull Dynamic dynamic) {
        return Companion.setFromDynamic(dynamic);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/uimanager/LengthPercentage$Companion;", "", "()V", "setFromDynamic", "Lcom/facebook/react/uimanager/LengthPercentage;", "dynamic", "Lcom/facebook/react/bridge/Dynamic;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final LengthPercentage setFromDynamic(@NotNull Dynamic dynamic) {
            Intrinsics.checkNotNullParameter((Object)dynamic, (String)"dynamic");
            return switch (WhenMappings.$EnumSwitchMapping$0[dynamic.getType().ordinal()]) {
                case 1 -> {
                    double value = dynamic.asDouble();
                    if (value >= 0.0) {
                        yield new LengthPercentage((float)value, LengthPercentageType.POINT);
                    }
                    yield null;
                }
                case 2 -> {
                    String s = dynamic.asString();
                    if (StringsKt.endsWith$default((String)s, (String)"%", (boolean)false, (int)2, null)) {
                        LengthPercentage var3_5;
                        try {
                            String v1 = s.substring(0, s.length() - 1);
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                            float value = Float.parseFloat(v1);
                            var3_5 = value >= 0.0f ? new LengthPercentage(value, LengthPercentageType.PERCENT) : null;
                        }
                        catch (NumberFormatException e) {
                            FLog.w((String)"ReactNative", (String)("Invalid percentage format: " + s));
                            var3_5 = null;
                        }
                        yield var3_5;
                    }
                    FLog.w((String)"ReactNative", (String)("Invalid string value: " + s));
                    yield null;
                }
                default -> {
                    FLog.w((String)"ReactNative", (String)("Unsupported type for radius property: " + dynamic.getType()));
                    yield null;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ReadableType.values().length];
                try {
                    nArray[ReadableType.Number.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReadableType.String.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

