/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromObject;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.BaseViewManagerInterface;
import com.facebook.react.uimanager.ViewManagerDelegate;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J)\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0012\u0010\u0006\u001a\u00028\u00018\u0004X\u0085\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/uimanager/BaseViewManagerDelegate;", "T", "Landroid/view/View;", "U", "Lcom/facebook/react/uimanager/BaseViewManagerInterface;", "Lcom/facebook/react/uimanager/ViewManagerDelegate;", "mViewManager", "(Lcom/facebook/react/uimanager/BaseViewManagerInterface;)V", "Lcom/facebook/react/uimanager/BaseViewManagerInterface;", "receiveCommand", "", "view", "commandName", "", "args", "Lcom/facebook/react/bridge/ReadableArray;", "(Landroid/view/View;Ljava/lang/String;Lcom/facebook/react/bridge/ReadableArray;)V", "setProperty", "propName", "value", "", "(Landroid/view/View;Ljava/lang/String;Ljava/lang/Object;)V", "ReactAndroid_debug"})
public abstract class BaseViewManagerDelegate<T extends View, U extends BaseViewManagerInterface<T>>
implements ViewManagerDelegate<T> {
    @JvmField
    @NotNull
    protected final U mViewManager;

    public BaseViewManagerDelegate(@NotNull U mViewManager) {
        Intrinsics.checkNotNullParameter(mViewManager, (String)"mViewManager");
        this.mViewManager = mViewManager;
    }

    @Override
    public void setProperty(@NotNull T view, @Nullable String propName, @Nullable Object value) {
        block97: {
            Intrinsics.checkNotNullParameter(view, (String)"view");
            String string2 = propName;
            if (string2 == null) break block97;
            int n = -1;
            switch (string2.hashCode()) {
                case -80891667: {
                    if (string2.equals("renderToHardwareTextureAndroid")) {
                        n = 1;
                    }
                    break;
                }
                case 746986311: {
                    if (string2.equals("importantForAccessibility")) {
                        n = 2;
                    }
                    break;
                }
                case 3506294: {
                    if (string2.equals("role")) {
                        n = 3;
                    }
                    break;
                }
                case -101663499: {
                    if (string2.equals("accessibilityHint")) {
                        n = 4;
                    }
                    break;
                }
                case 36255470: {
                    if (string2.equals("accessibilityLiveRegion")) {
                        n = 5;
                    }
                    break;
                }
                case 1761903244: {
                    if (string2.equals("accessibilityCollection")) {
                        n = 6;
                    }
                    break;
                }
                case -908189618: {
                    if (string2.equals("scaleX")) {
                        n = 7;
                    }
                    break;
                }
                case -101359900: {
                    if (string2.equals("accessibilityRole")) {
                        n = 8;
                    }
                    break;
                }
                case 1865277756: {
                    if (string2.equals("accessibilityLabelledBy")) {
                        n = 9;
                    }
                    break;
                }
                case -908189617: {
                    if (string2.equals("scaleY")) {
                        n = 10;
                    }
                    break;
                }
                case 1052666732: {
                    if (string2.equals("transform")) {
                        n = 11;
                    }
                    break;
                }
                case -1721943861: {
                    if (string2.equals("translateY")) {
                        n = 12;
                    }
                    break;
                }
                case -1721943862: {
                    if (string2.equals("translateX")) {
                        n = 13;
                    }
                    break;
                }
                case 588239831: {
                    if (string2.equals("borderBottomRightRadius")) {
                        n = 14;
                    }
                    break;
                }
                case 333432965: {
                    if (string2.equals("borderTopRightRadius")) {
                        n = 15;
                    }
                    break;
                }
                case -877170387: {
                    if (string2.equals("testID")) {
                        n = 16;
                    }
                    break;
                }
                case -781597262: {
                    if (string2.equals("transformOrigin")) {
                        n = 17;
                    }
                    break;
                }
                case 2045685618: {
                    if (string2.equals("nativeID")) {
                        n = 18;
                    }
                    break;
                }
                case 1146842694: {
                    if (string2.equals("accessibilityLabel")) {
                        n = 19;
                    }
                    break;
                }
                case -1589741021: {
                    if (string2.equals("shadowColor")) {
                        n = 20;
                    }
                    break;
                }
                case -731417480: {
                    if (string2.equals("zIndex")) {
                        n = 21;
                    }
                    break;
                }
                case -4379043: {
                    if (string2.equals("elevation")) {
                        n = 22;
                    }
                    break;
                }
                case 1287124693: {
                    if (string2.equals("backgroundColor")) {
                        n = 23;
                    }
                    break;
                }
                case 1153872867: {
                    if (string2.equals("accessibilityState")) {
                        n = 24;
                    }
                    break;
                }
                case -40300674: {
                    if (string2.equals("rotation")) {
                        n = 25;
                    }
                    break;
                }
                case -1228066334: {
                    if (string2.equals("borderTopLeftRadius")) {
                        n = 26;
                    }
                    break;
                }
                case 1505602511: {
                    if (string2.equals("accessibilityActions")) {
                        n = 27;
                    }
                    break;
                }
                case 1993034687: {
                    if (string2.equals("accessibilityCollectionItem")) {
                        n = 28;
                    }
                    break;
                }
                case 1349188574: {
                    if (string2.equals("borderRadius")) {
                        n = 29;
                    }
                    break;
                }
                case 581268560: {
                    if (string2.equals("borderBottomLeftRadius")) {
                        n = 30;
                    }
                    break;
                }
                case -1267206133: {
                    if (string2.equals("opacity")) {
                        n = 31;
                    }
                    break;
                }
            }
            switch (n) {
                case 27: {
                    this.mViewManager.setAccessibilityActions(view, (ReadableArray)value);
                    break;
                }
                case 4: {
                    this.mViewManager.setAccessibilityHint(view, (String)value);
                    break;
                }
                case 19: {
                    this.mViewManager.setAccessibilityLabel(view, (String)value);
                    break;
                }
                case 5: {
                    this.mViewManager.setAccessibilityLiveRegion(view, (String)value);
                    break;
                }
                case 8: {
                    this.mViewManager.setAccessibilityRole(view, (String)value);
                    break;
                }
                case 24: {
                    this.mViewManager.setViewState(view, (ReadableMap)value);
                    break;
                }
                case 6: {
                    this.mViewManager.setAccessibilityCollection(view, (ReadableMap)value);
                    break;
                }
                case 28: {
                    this.mViewManager.setAccessibilityCollectionItem(view, (ReadableMap)value);
                    break;
                }
                case 23: {
                    Object object = value;
                    Integer n2 = object == null ? Integer.valueOf(0) : ColorPropConverter.getColor(object, view.getContext());
                    Intrinsics.checkNotNull((Object)n2);
                    this.mViewManager.setBackgroundColor(view, ((Number)n2).intValue());
                    break;
                }
                case 29: {
                    Double d = (Double)value;
                    this.mViewManager.setBorderRadius(view, d != null ? (float)d.doubleValue() : Float.NaN);
                    break;
                }
                case 30: {
                    Double d = (Double)value;
                    this.mViewManager.setBorderBottomLeftRadius(view, d != null ? (float)d.doubleValue() : Float.NaN);
                    break;
                }
                case 14: {
                    Double d = (Double)value;
                    this.mViewManager.setBorderBottomRightRadius(view, d != null ? (float)d.doubleValue() : Float.NaN);
                    break;
                }
                case 26: {
                    Double d = (Double)value;
                    this.mViewManager.setBorderTopLeftRadius(view, d != null ? (float)d.doubleValue() : Float.NaN);
                    break;
                }
                case 15: {
                    Double d = (Double)value;
                    this.mViewManager.setBorderTopRightRadius(view, d != null ? (float)d.doubleValue() : Float.NaN);
                    break;
                }
                case 22: {
                    Double d = (Double)value;
                    this.mViewManager.setElevation(view, d != null ? (float)d.doubleValue() : 0.0f);
                    break;
                }
                case 20: {
                    Object object = value;
                    Integer n3 = object == null ? Integer.valueOf(0) : ColorPropConverter.getColor(object, view.getContext());
                    Intrinsics.checkNotNull((Object)n3);
                    this.mViewManager.setShadowColor(view, ((Number)n3).intValue());
                    break;
                }
                case 2: {
                    this.mViewManager.setImportantForAccessibility(view, (String)value);
                    break;
                }
                case 3: {
                    this.mViewManager.setRole(view, (String)value);
                    break;
                }
                case 18: {
                    this.mViewManager.setNativeId(view, (String)value);
                    break;
                }
                case 9: {
                    Dynamic dynamicFromObject = new DynamicFromObject(value);
                    this.mViewManager.setAccessibilityLabelledBy(view, dynamicFromObject);
                    break;
                }
                case 31: {
                    Double d = (Double)value;
                    this.mViewManager.setOpacity(view, d != null ? (float)d.doubleValue() : 1.0f);
                    break;
                }
                case 1: {
                    Boolean bl = (Boolean)value;
                    this.mViewManager.setRenderToHardwareTexture(view, bl != null ? bl : false);
                    break;
                }
                case 25: {
                    Double d = (Double)value;
                    this.mViewManager.setRotation(view, d != null ? (float)d.doubleValue() : 0.0f);
                    break;
                }
                case 7: {
                    Double d = (Double)value;
                    this.mViewManager.setScaleX(view, d != null ? (float)d.doubleValue() : 1.0f);
                    break;
                }
                case 10: {
                    Double d = (Double)value;
                    this.mViewManager.setScaleY(view, d != null ? (float)d.doubleValue() : 1.0f);
                    break;
                }
                case 16: {
                    this.mViewManager.setTestId(view, (String)value);
                    break;
                }
                case 11: {
                    this.mViewManager.setTransform(view, (ReadableArray)value);
                    break;
                }
                case 17: {
                    this.mViewManager.setTransformOrigin(view, (ReadableArray)value);
                    break;
                }
                case 13: {
                    Double d = (Double)value;
                    this.mViewManager.setTranslateX(view, d != null ? (float)d.doubleValue() : 0.0f);
                    break;
                }
                case 12: {
                    Double d = (Double)value;
                    this.mViewManager.setTranslateY(view, d != null ? (float)d.doubleValue() : 0.0f);
                    break;
                }
                case 21: {
                    Double d = (Double)value;
                    this.mViewManager.setZIndex(view, d != null ? (float)d.doubleValue() : 0.0f);
                }
            }
        }
    }

    @Override
    public void receiveCommand(@NotNull T view, @Nullable String commandName, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
    }
}

