/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.devtoolssettings;

import android.content.SharedPreferences;
import com.facebook.fbreact.specs.NativeDevToolsSettingsManagerSpec;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.module.annotations.ReactModule;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="DevToolsSettingsManager")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\r\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/modules/devtoolssettings/DevToolsSettingsManagerModule;", "Lcom/facebook/fbreact/specs/NativeDevToolsSettingsManagerSpec;", "reactContext", "Lcom/facebook/react/bridge/ReactApplicationContext;", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "sharedPreferences", "Landroid/content/SharedPreferences;", "getConsolePatchSettings", "", "getProfilingSettings", "setConsolePatchSettings", "", "newSettings", "setProfilingSettings", "Companion", "ReactAndroid_debug"})
public final class DevToolsSettingsManagerModule
extends NativeDevToolsSettingsManagerSpec {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SharedPreferences sharedPreferences;
    @NotNull
    private static final String SHARED_PREFERENCES_PREFIX = "ReactNative__DevToolsSettings";
    @NotNull
    private static final String KEY_CONSOLE_PATCH_SETTINGS = "ConsolePatchSettings";
    @NotNull
    private static final String KEY_PROFILING_SETTINGS = "ProfilingSettings";

    public DevToolsSettingsManagerModule(@NotNull ReactApplicationContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        super(reactContext);
        SharedPreferences sharedPreferences = reactContext.getSharedPreferences(SHARED_PREFERENCES_PREFIX, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        this.sharedPreferences = sharedPreferences;
    }

    @Override
    @Nullable
    public String getConsolePatchSettings() {
        return this.sharedPreferences.getString(KEY_CONSOLE_PATCH_SETTINGS, null);
    }

    @Override
    public void setConsolePatchSettings(@Nullable String newSettings) {
        this.sharedPreferences.edit().putString(KEY_CONSOLE_PATCH_SETTINGS, newSettings).apply();
    }

    @Override
    @Nullable
    public String getProfilingSettings() {
        return this.sharedPreferences.getString(KEY_PROFILING_SETTINGS, null);
    }

    @Override
    public void setProfilingSettings(@Nullable String newSettings) {
        this.sharedPreferences.edit().putString(KEY_PROFILING_SETTINGS, newSettings).apply();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/modules/devtoolssettings/DevToolsSettingsManagerModule$Companion;", "", "()V", "KEY_CONSOLE_PATCH_SETTINGS", "", "KEY_PROFILING_SETTINGS", "SHARED_PREFERENCES_PREFIX", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

