/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerListener;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.view.ReactViewGroup;
import java.lang.ref.WeakReference;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class MaintainVisibleScrollPositionHelper<ScrollViewT extends ViewGroup>
implements UIManagerListener {
    private final ScrollViewT mScrollView;
    private final boolean mHorizontal;
    @Nullable
    private Config mConfig;
    @Nullable
    private WeakReference<View> mFirstVisibleView = null;
    @Nullable
    private Rect mPrevFirstVisibleFrame = null;
    private boolean mListening = false;

    public MaintainVisibleScrollPositionHelper(ScrollViewT scrollView, boolean horizontal) {
        this.mScrollView = scrollView;
        this.mHorizontal = horizontal;
    }

    public void setConfig(@Nullable Config config) {
        this.mConfig = config;
    }

    public void start() {
        if (this.mListening) {
            return;
        }
        this.mListening = true;
        this.getUIManagerModule().addUIManagerEventListener(this);
    }

    public void stop() {
        if (!this.mListening) {
            return;
        }
        this.mListening = false;
        this.getUIManagerModule().removeUIManagerEventListener(this);
    }

    public void updateScrollPosition() {
        if (ViewUtil.getUIManagerType(this.mScrollView.getId()) == 2) {
            return;
        }
        this.updateScrollPositionInternal();
    }

    private void updateScrollPositionInternal() {
        if (this.mConfig == null || this.mFirstVisibleView == null || this.mPrevFirstVisibleFrame == null) {
            return;
        }
        View firstVisibleView = (View)this.mFirstVisibleView.get();
        if (firstVisibleView == null) {
            return;
        }
        Rect newFrame = new Rect();
        firstVisibleView.getHitRect(newFrame);
        if (this.mHorizontal) {
            int deltaX = newFrame.left - this.mPrevFirstVisibleFrame.left;
            if (deltaX != 0) {
                int scrollX = this.mScrollView.getScrollX();
                ((ReactScrollViewHelper.HasSmoothScroll)this.mScrollView).scrollToPreservingMomentum(scrollX + deltaX, this.mScrollView.getScrollY());
                this.mPrevFirstVisibleFrame = newFrame;
                if (this.mConfig.autoScrollToTopThreshold != null && scrollX <= this.mConfig.autoScrollToTopThreshold) {
                    ((ReactScrollViewHelper.HasSmoothScroll)this.mScrollView).reactSmoothScrollTo(0, this.mScrollView.getScrollY());
                }
            }
        } else {
            int deltaY = newFrame.top - this.mPrevFirstVisibleFrame.top;
            if (deltaY != 0) {
                int scrollY = this.mScrollView.getScrollY();
                ((ReactScrollViewHelper.HasSmoothScroll)this.mScrollView).scrollToPreservingMomentum(this.mScrollView.getScrollX(), scrollY + deltaY);
                this.mPrevFirstVisibleFrame = newFrame;
                if (this.mConfig.autoScrollToTopThreshold != null && scrollY <= this.mConfig.autoScrollToTopThreshold) {
                    ((ReactScrollViewHelper.HasSmoothScroll)this.mScrollView).reactSmoothScrollTo(this.mScrollView.getScrollX(), 0);
                }
            }
        }
    }

    @Nullable
    private ReactViewGroup getContentView() {
        return (ReactViewGroup)this.mScrollView.getChildAt(0);
    }

    private UIManager getUIManagerModule() {
        return (UIManager)Assertions.assertNotNull((Object)UIManagerHelper.getUIManager((ReactContext)this.mScrollView.getContext(), ViewUtil.getUIManagerType(this.mScrollView.getId())));
    }

    private void computeTargetView() {
        if (this.mConfig == null) {
            return;
        }
        ReactViewGroup contentView = this.getContentView();
        if (contentView == null) {
            return;
        }
        int currentScroll = this.mHorizontal ? this.mScrollView.getScrollX() : this.mScrollView.getScrollY();
        for (int i = this.mConfig.minIndexForVisible; i < contentView.getChildCount(); ++i) {
            float position;
            View child = contentView.getChildAt(i);
            float f = position = this.mHorizontal ? child.getX() + (float)child.getWidth() : child.getY() + (float)child.getHeight();
            if (!(position > (float)currentScroll) && i != contentView.getChildCount() - 1) continue;
            this.mFirstVisibleView = new WeakReference<View>(child);
            Rect frame = new Rect();
            child.getHitRect(frame);
            this.mPrevFirstVisibleFrame = frame;
            break;
        }
    }

    @Override
    public void willDispatchViewUpdates(UIManager uiManager) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MaintainVisibleScrollPositionHelper.this.computeTargetView();
            }
        });
    }

    @Override
    public void willMountItems(UIManager uiManager) {
        this.computeTargetView();
    }

    @Override
    public void didMountItems(UIManager uiManager) {
        this.updateScrollPositionInternal();
    }

    @Override
    public void didDispatchMountItems(UIManager uiManager) {
    }

    @Override
    public void didScheduleMountItems(UIManager uiManager) {
    }

    public static class Config {
        public final int minIndexForVisible;
        @Nullable
        public final Integer autoScrollToTopThreshold;

        Config(int minIndexForVisible, @Nullable Integer autoScrollToTopThreshold) {
            this.minIndexForVisible = minIndexForVisible;
            this.autoScrollToTopThreshold = autoScrollToTopThreshold;
        }

        static Config fromReadableMap(ReadableMap value) {
            int minIndexForVisible = value.getInt("minIndexForVisible");
            Integer autoScrollToTopThreshold = value.hasKey("autoscrollToTopThreshold") ? Integer.valueOf(value.getInt("autoscrollToTopThreshold")) : null;
            return new Config(minIndexForVisible, autoScrollToTopThreshold);
        }
    }
}

