/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.OverScroller;
import android.widget.ScrollView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.R;
import com.facebook.react.animated.NativeAnimatedModule;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import com.facebook.react.uimanager.ReactClippingViewGroupHelper;
import com.facebook.react.uimanager.ReactOverflowViewWithInset;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.uimanager.style.Overflow;
import com.facebook.react.views.scroll.FpsListener;
import com.facebook.react.views.scroll.MaintainVisibleScrollPositionHelper;
import com.facebook.react.views.scroll.OnScrollDispatchHelper;
import com.facebook.react.views.scroll.ReactScrollViewAccessibilityDelegate;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.scroll.VelocityHelper;
import com.facebook.react.views.view.ReactViewBackgroundManager;
import java.lang.reflect.Field;
import java.util.List;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactScrollView
extends ScrollView
implements ReactClippingViewGroup,
ViewGroup.OnHierarchyChangeListener,
View.OnLayoutChangeListener,
ReactOverflowViewWithInset,
ReactScrollViewHelper.HasScrollState,
ReactScrollViewHelper.HasStateWrapper,
ReactScrollViewHelper.HasFlingAnimator,
ReactScrollViewHelper.HasScrollEventThrottle,
ReactScrollViewHelper.HasSmoothScroll {
    @Nullable
    private static Field sScrollerField;
    private static boolean sTriedToGetScrollerField;
    private static final int UNSET_CONTENT_OFFSET = -1;
    private final OnScrollDispatchHelper mOnScrollDispatchHelper = new OnScrollDispatchHelper();
    @Nullable
    private final OverScroller mScroller;
    private final VelocityHelper mVelocityHelper = new VelocityHelper();
    private final Rect mTempRect = new Rect();
    private final Rect mOverflowInset = new Rect();
    private boolean mActivelyScrolling;
    @Nullable
    private Rect mClippingRect;
    private Overflow mOverflow = Overflow.SCROLL;
    private boolean mDragging;
    private boolean mPagingEnabled = false;
    @Nullable
    private Runnable mPostTouchRunnable;
    private boolean mRemoveClippedSubviews;
    private boolean mScrollEnabled = true;
    private boolean mPreventReentry = false;
    private boolean mSendMomentumEvents;
    @Nullable
    private FpsListener mFpsListener = null;
    @Nullable
    private String mScrollPerfTag;
    private boolean mEnableSyncOnScroll = false;
    @Nullable
    private Drawable mEndBackground;
    private int mEndFillColor = 0;
    private boolean mDisableIntervalMomentum = false;
    private int mSnapInterval = 0;
    @Nullable
    private List<Integer> mSnapOffsets;
    private boolean mSnapToStart = true;
    private boolean mSnapToEnd = true;
    private int mSnapToAlignment = 0;
    @Nullable
    private View mContentView;
    private ReactViewBackgroundManager mReactBackgroundManager;
    @Nullable
    private ReadableMap mCurrentContentOffset = null;
    private int pendingContentOffsetX = -1;
    private int pendingContentOffsetY = -1;
    @Nullable
    private StateWrapper mStateWrapper = null;
    private final ReactScrollViewHelper.ReactScrollViewScrollState mReactScrollViewScrollState = new ReactScrollViewHelper.ReactScrollViewScrollState(0);
    private final ValueAnimator DEFAULT_FLING_ANIMATOR = ObjectAnimator.ofInt((Object)this, (String)"scrollY", (int[])new int[]{0, 0});
    private PointerEvents mPointerEvents = PointerEvents.AUTO;
    private long mLastScrollDispatchTime = 0L;
    private int mScrollEventThrottle = 0;
    @Nullable
    private MaintainVisibleScrollPositionHelper mMaintainVisibleContentPositionHelper = null;

    public ReactScrollView(Context context) {
        this(context, null);
    }

    public ReactScrollView(Context context, @Nullable FpsListener fpsListener) {
        super(context);
        this.mFpsListener = fpsListener;
        this.mReactBackgroundManager = new ReactViewBackgroundManager((View)this);
        this.mScroller = this.getOverScrollerFromParent();
        this.setOnHierarchyChangeListener(this);
        this.setScrollBarStyle(0x2000000);
        this.setClipChildren(false);
        this.mReactBackgroundManager.setOverflow("scroll");
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)new ReactScrollViewAccessibilityDelegate());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        String testId = (String)this.getTag(R.id.react_test_id);
        if (testId != null) {
            info.setViewIdResourceName(testId);
        }
    }

    @Nullable
    private OverScroller getOverScrollerFromParent() {
        OverScroller scroller;
        if (!sTriedToGetScrollerField) {
            sTriedToGetScrollerField = true;
            try {
                sScrollerField = ScrollView.class.getDeclaredField("mScroller");
                sScrollerField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                FLog.w((String)"ReactNative", (String)"Failed to get mScroller field for ScrollView! This app will exhibit the bounce-back scrolling bug :(");
            }
        }
        if (sScrollerField != null) {
            try {
                Object scrollerValue = sScrollerField.get(this);
                if (scrollerValue instanceof OverScroller) {
                    scroller = (OverScroller)scrollerValue;
                }
                FLog.w((String)"ReactNative", (String)"Failed to cast mScroller field in ScrollView (probably due to OEM changes to AOSP)! This app will exhibit the bounce-back scrolling bug :(");
                scroller = null;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get mScroller from ScrollView!", e);
            }
        } else {
            scroller = null;
        }
        return scroller;
    }

    public void setDisableIntervalMomentum(boolean disableIntervalMomentum) {
        this.mDisableIntervalMomentum = disableIntervalMomentum;
    }

    public void setSendMomentumEvents(boolean sendMomentumEvents) {
        this.mSendMomentumEvents = sendMomentumEvents;
    }

    public void setScrollPerfTag(@Nullable String scrollPerfTag) {
        this.mScrollPerfTag = scrollPerfTag;
    }

    public void setEnableSyncOnScroll(boolean enableSyncOnScroll) {
        this.mEnableSyncOnScroll = enableSyncOnScroll;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.mScrollEnabled = scrollEnabled;
    }

    public boolean getScrollEnabled() {
        return this.mScrollEnabled;
    }

    public void setPagingEnabled(boolean pagingEnabled) {
        this.mPagingEnabled = pagingEnabled;
    }

    public void setDecelerationRate(float decelerationRate) {
        this.getReactScrollViewScrollState().setDecelerationRate(decelerationRate);
        if (this.mScroller != null) {
            this.mScroller.setFriction(1.0f - decelerationRate);
        }
    }

    public void abortAnimation() {
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
    }

    public void setSnapInterval(int snapInterval) {
        this.mSnapInterval = snapInterval;
    }

    public void setSnapOffsets(@Nullable List<Integer> snapOffsets) {
        this.mSnapOffsets = snapOffsets;
    }

    public void setSnapToStart(boolean snapToStart) {
        this.mSnapToStart = snapToStart;
    }

    public void setSnapToEnd(boolean snapToEnd) {
        this.mSnapToEnd = snapToEnd;
    }

    public void setSnapToAlignment(int snapToAlignment) {
        this.mSnapToAlignment = snapToAlignment;
    }

    public void flashScrollIndicators() {
        this.awakenScrollBars();
    }

    public void setOverflow(@Nullable String overflow) {
        Overflow parsedOverflow;
        this.mOverflow = overflow == null ? Overflow.SCROLL : ((parsedOverflow = Overflow.fromString(overflow)) == null ? Overflow.SCROLL : parsedOverflow);
        this.mReactBackgroundManager.setOverflow(overflow == null ? "scroll" : overflow);
        this.invalidate();
    }

    public void setMaintainVisibleContentPosition(@Nullable MaintainVisibleScrollPositionHelper.Config config) {
        if (config != null && this.mMaintainVisibleContentPositionHelper == null) {
            this.mMaintainVisibleContentPositionHelper = new MaintainVisibleScrollPositionHelper<ReactScrollView>(this, false);
            this.mMaintainVisibleContentPositionHelper.start();
        } else if (config == null && this.mMaintainVisibleContentPositionHelper != null) {
            this.mMaintainVisibleContentPositionHelper.stop();
            this.mMaintainVisibleContentPositionHelper = null;
        }
        if (this.mMaintainVisibleContentPositionHelper != null) {
            this.mMaintainVisibleContentPositionHelper.setConfig(config);
        }
    }

    @Override
    @Nullable
    public String getOverflow() {
        switch (this.mOverflow) {
            case HIDDEN: {
                return "hidden";
            }
            case SCROLL: {
                return "scroll";
            }
            case VISIBLE: {
                return "visible";
            }
        }
        return null;
    }

    @Override
    public void setOverflowInset(int left, int top, int right, int bottom) {
        this.mOverflowInset.set(left, top, right, bottom);
    }

    @Override
    public Rect getOverflowInset() {
        return this.mOverflowInset;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.isContentReady()) {
            int scrollToX = this.pendingContentOffsetX != -1 ? this.pendingContentOffsetX : this.getScrollX();
            int scrollToY = this.pendingContentOffsetY != -1 ? this.pendingContentOffsetY : this.getScrollY();
            this.scrollTo(scrollToX, scrollToY);
        }
        ReactScrollViewHelper.emitLayoutEvent((ViewGroup)this);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
        if (this.mMaintainVisibleContentPositionHelper != null) {
            this.mMaintainVisibleContentPositionHelper.start();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mMaintainVisibleContentPositionHelper != null) {
            this.mMaintainVisibleContentPositionHelper.stop();
        }
    }

    public void requestChildFocus(View child, View focused) {
        if (focused != null) {
            this.scrollToChild(focused);
        }
        super.requestChildFocus(child, focused);
    }

    private int getScrollDelta(View descendent) {
        descendent.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendent, this.mTempRect);
        return this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
    }

    boolean isPartiallyScrolledInView(View descendent) {
        int scrollDelta = this.getScrollDelta(descendent);
        descendent.getDrawingRect(this.mTempRect);
        return scrollDelta != 0 && Math.abs(scrollDelta) < this.mTempRect.width();
    }

    private void scrollToChild(View child) {
        Rect tempRect = new Rect();
        child.getDrawingRect(tempRect);
        this.offsetDescendantRectToMyCoords(child, tempRect);
        int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(tempRect);
        if (scrollDelta != 0) {
            this.scrollBy(0, scrollDelta);
        }
    }

    protected void onScrollChanged(int x, int y, int oldX, int oldY) {
        super.onScrollChanged(x, y, oldX, oldY);
        this.mActivelyScrolling = true;
        if (this.mOnScrollDispatchHelper.onScrollChanged(x, y)) {
            if (this.mRemoveClippedSubviews) {
                this.updateClippingRect();
            }
            if (this.mPreventReentry) {
                return;
            }
            this.mPreventReentry = true;
            ReactScrollViewHelper.updateStateOnScrollChanged(this, this.mOnScrollDispatchHelper.getXFlingVelocity(), this.mOnScrollDispatchHelper.getYFlingVelocity(), this.mEnableSyncOnScroll);
            this.mPreventReentry = false;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        if (!PointerEvents.canChildrenBeTouchTarget(this.mPointerEvents)) {
            return true;
        }
        try {
            if (super.onInterceptTouchEvent(ev)) {
                this.handleInterceptedTouchEvent(ev);
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            FLog.w((String)"ReactNative", (String)"Error intercepting touch event.", (Throwable)e);
        }
        return false;
    }

    protected void handleInterceptedTouchEvent(MotionEvent ev) {
        NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
        ReactScrollViewHelper.emitScrollBeginDragEvent(this);
        this.mDragging = true;
        this.enableFpsListener();
        this.getFlingAnimator().cancel();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        if (!PointerEvents.canBeTouchTarget(this.mPointerEvents)) {
            return false;
        }
        this.mVelocityHelper.calculateVelocity(ev);
        int action = ev.getActionMasked();
        if (action == 1 && this.mDragging) {
            ReactScrollViewHelper.updateFabricScrollState(this);
            float velocityX = this.mVelocityHelper.getXVelocity();
            float velocityY = this.mVelocityHelper.getYVelocity();
            ReactScrollViewHelper.emitScrollEndDragEvent(this, velocityX, velocityY);
            NativeGestureUtil.notifyNativeGestureEnded((View)this, ev);
            this.mDragging = false;
            this.handlePostTouchScrolling(Math.round(velocityX), Math.round(velocityY));
        }
        if (action == 0) {
            this.cancelPostTouchScrolling();
        }
        return super.onTouchEvent(ev);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent ev) {
        if (!PointerEvents.canChildrenBeTouchTarget(this.mPointerEvents)) {
            return false;
        }
        return super.dispatchGenericMotionEvent(ev);
    }

    public boolean executeKeyEvent(KeyEvent event) {
        int eventKeyCode = event.getKeyCode();
        if (!(this.mScrollEnabled || eventKeyCode != 19 && eventKeyCode != 20)) {
            return false;
        }
        return super.executeKeyEvent(event);
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (removeClippedSubviews && this.mClippingRect == null) {
            this.mClippingRect = new Rect();
        }
        this.mRemoveClippedSubviews = removeClippedSubviews;
        this.updateClippingRect();
    }

    @Override
    public boolean getRemoveClippedSubviews() {
        return this.mRemoveClippedSubviews;
    }

    @Override
    public void updateClippingRect() {
        if (!this.mRemoveClippedSubviews) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
        View contentView = this.getContentView();
        if (contentView instanceof ReactClippingViewGroup) {
            ((ReactClippingViewGroup)contentView).updateClippingRect();
        }
    }

    @Override
    public void getClippingRect(Rect outClippingRect) {
        outClippingRect.set((Rect)Assertions.assertNotNull((Object)this.mClippingRect));
    }

    public boolean getChildVisibleRect(View child, Rect r, Point offset) {
        return super.getChildVisibleRect(child, r, offset);
    }

    public void fling(int velocityY) {
        int correctedVelocityY = this.correctFlingVelocityY(velocityY);
        if (this.mPagingEnabled) {
            this.flingAndSnap(correctedVelocityY);
        } else if (this.mScroller != null) {
            int scrollWindowHeight = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), 0, correctedVelocityY, 0, 0, 0, Integer.MAX_VALUE, 0, scrollWindowHeight / 2);
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            super.fling(correctedVelocityY);
        }
        this.handlePostTouchScrolling(0, correctedVelocityY);
    }

    private int correctFlingVelocityY(int velocityY) {
        if (Build.VERSION.SDK_INT != 28) {
            return velocityY;
        }
        float signum = Math.signum(this.mOnScrollDispatchHelper.getYFlingVelocity());
        if (signum == 0.0f) {
            signum = Math.signum(velocityY);
        }
        return (int)((float)Math.abs(velocityY) * signum);
    }

    private void enableFpsListener() {
        if (this.isScrollPerfLoggingEnabled()) {
            Assertions.assertNotNull((Object)this.mFpsListener);
            Assertions.assertNotNull((Object)this.mScrollPerfTag);
            this.mFpsListener.enable(this.mScrollPerfTag);
        }
    }

    private void disableFpsListener() {
        if (this.isScrollPerfLoggingEnabled()) {
            Assertions.assertNotNull((Object)this.mFpsListener);
            Assertions.assertNotNull((Object)this.mScrollPerfTag);
            this.mFpsListener.disable(this.mScrollPerfTag);
        }
    }

    private boolean isScrollPerfLoggingEnabled() {
        return this.mFpsListener != null && this.mScrollPerfTag != null && !this.mScrollPerfTag.isEmpty();
    }

    private int getMaxScrollY() {
        int contentHeight = this.mContentView == null ? 0 : this.mContentView.getHeight();
        int viewportHeight = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        return Math.max(0, contentHeight - viewportHeight);
    }

    @Override
    @Nullable
    public StateWrapper getStateWrapper() {
        return this.mStateWrapper;
    }

    public void setStateWrapper(StateWrapper stateWrapper) {
        this.mStateWrapper = stateWrapper;
    }

    public void draw(Canvas canvas) {
        if (this.mEndFillColor != 0) {
            View contentView = this.getContentView();
            if (this.mEndBackground != null && contentView != null && contentView.getBottom() < this.getHeight()) {
                this.mEndBackground.setBounds(0, contentView.getBottom(), this.getWidth(), this.getHeight());
                this.mEndBackground.draw(canvas);
            }
        }
        super.draw(canvas);
    }

    public void onDraw(Canvas canvas) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            if (this.mOverflow != Overflow.VISIBLE) {
                BackgroundStyleApplicator.clipToPaddingBox((View)this, canvas);
            }
        } else {
            this.mReactBackgroundManager.maybeClipToPaddingBox(canvas);
        }
        super.onDraw(canvas);
    }

    private void handlePostTouchScrolling(int velocityX, int velocityY) {
        if (this.mPostTouchRunnable != null) {
            return;
        }
        if (this.mSendMomentumEvents) {
            this.enableFpsListener();
            ReactScrollViewHelper.emitScrollMomentumBeginEvent(this, velocityX, velocityY);
        }
        this.mActivelyScrolling = false;
        this.mPostTouchRunnable = new Runnable(){
            private boolean mSnappingToPage = false;
            private int mStableFrames = 0;

            @Override
            public void run() {
                if (ReactScrollView.this.mActivelyScrolling) {
                    ReactScrollView.this.mActivelyScrolling = false;
                    this.mStableFrames = 0;
                    ViewCompat.postOnAnimationDelayed((View)ReactScrollView.this, (Runnable)this, (long)20L);
                } else {
                    ReactScrollViewHelper.updateFabricScrollState(ReactScrollView.this);
                    ++this.mStableFrames;
                    if (this.mStableFrames >= 3) {
                        NativeAnimatedModule nativeAnimated;
                        ReactContext context;
                        ReactScrollView.this.mPostTouchRunnable = null;
                        if (ReactScrollView.this.mSendMomentumEvents) {
                            ReactScrollViewHelper.emitScrollMomentumEndEvent(ReactScrollView.this);
                        }
                        if ((context = (ReactContext)ReactScrollView.this.getContext()) != null && (nativeAnimated = context.getNativeModule(NativeAnimatedModule.class)) != null) {
                            nativeAnimated.userDrivenScrollEnded(ReactScrollView.this.getId());
                        }
                        ReactScrollView.this.disableFpsListener();
                    } else {
                        if (ReactScrollView.this.mPagingEnabled && !this.mSnappingToPage) {
                            this.mSnappingToPage = true;
                            ReactScrollView.this.flingAndSnap(0);
                        }
                        ViewCompat.postOnAnimationDelayed((View)ReactScrollView.this, (Runnable)this, (long)20L);
                    }
                }
            }
        };
        ViewCompat.postOnAnimationDelayed((View)this, (Runnable)this.mPostTouchRunnable, (long)20L);
    }

    private void cancelPostTouchScrolling() {
        if (this.mPostTouchRunnable != null) {
            this.removeCallbacks(this.mPostTouchRunnable);
            this.mPostTouchRunnable = null;
            this.getFlingAnimator().cancel();
        }
    }

    private int predictFinalScrollPosition(int velocityY) {
        return this.getFlingAnimator() == this.DEFAULT_FLING_ANIMATOR ? ReactScrollViewHelper.predictFinalScrollPosition(this, (int)0, (int)velocityY, (int)0, (int)this.getMaxScrollY()).y : ReactScrollViewHelper.getNextFlingStartValue(this, this.getScrollY(), this.getReactScrollViewScrollState().getFinalAnimatedPositionScroll().y, velocityY) + this.getFlingExtrapolatedDistance(velocityY);
    }

    private View getContentView() {
        return this.getChildAt(0);
    }

    private void smoothScrollAndSnap(int velocity) {
        double interval = this.getSnapInterval();
        double currentOffset = ReactScrollViewHelper.getNextFlingStartValue(this, this.getScrollY(), this.getReactScrollViewScrollState().getFinalAnimatedPositionScroll().y, velocity);
        double targetOffset = this.predictFinalScrollPosition(velocity);
        int previousPage = (int)Math.floor(currentOffset / interval);
        int nextPage = (int)Math.ceil(currentOffset / interval);
        int currentPage = (int)Math.round(currentOffset / interval);
        int targetPage = (int)Math.round(targetOffset / interval);
        if (velocity > 0 && nextPage == previousPage) {
            ++nextPage;
        } else if (velocity < 0 && previousPage == nextPage) {
            --previousPage;
        }
        if (velocity > 0 && currentPage < nextPage && targetPage > previousPage) {
            currentPage = nextPage;
        } else if (velocity < 0 && currentPage > previousPage && targetPage < nextPage) {
            currentPage = previousPage;
        }
        targetOffset = (double)currentPage * interval;
        if (targetOffset != currentOffset) {
            this.mActivelyScrolling = true;
            this.reactSmoothScrollTo(this.getScrollX(), (int)targetOffset);
        }
    }

    private void flingAndSnap(int velocityY) {
        int nearestOffset;
        if (this.getChildCount() <= 0) {
            return;
        }
        if (this.mSnapInterval == 0 && this.mSnapOffsets == null && this.mSnapToAlignment == 0) {
            this.smoothScrollAndSnap(velocityY);
            return;
        }
        boolean hasCustomizedFlingAnimator = this.getFlingAnimator() != this.DEFAULT_FLING_ANIMATOR;
        int maximumOffset = this.getMaxScrollY();
        int targetOffset = this.predictFinalScrollPosition(velocityY);
        if (this.mDisableIntervalMomentum) {
            targetOffset = this.getScrollY();
        }
        int smallerOffset = 0;
        int largerOffset = maximumOffset;
        int firstOffset = 0;
        int lastOffset = maximumOffset;
        int height = this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        if (this.mSnapOffsets != null) {
            firstOffset = this.mSnapOffsets.get(0);
            lastOffset = this.mSnapOffsets.get(this.mSnapOffsets.size() - 1);
            for (int i = 0; i < this.mSnapOffsets.size(); ++i) {
                int offset = this.mSnapOffsets.get(i);
                if (offset <= targetOffset && targetOffset - offset < targetOffset - smallerOffset) {
                    smallerOffset = offset;
                }
                if (offset < targetOffset || offset - targetOffset >= largerOffset - targetOffset) continue;
                largerOffset = offset;
            }
        } else if (this.mSnapToAlignment != 0) {
            if (this.mSnapInterval > 0) {
                double ratio = (double)targetOffset / (double)this.mSnapInterval;
                smallerOffset = Math.max(this.getItemStartOffset(this.mSnapToAlignment, (int)(Math.floor(ratio) * (double)this.mSnapInterval), this.mSnapInterval, height), 0);
                largerOffset = Math.min(this.getItemStartOffset(this.mSnapToAlignment, (int)(Math.ceil(ratio) * (double)this.mSnapInterval), this.mSnapInterval, height), maximumOffset);
            } else {
                ViewGroup contentView = (ViewGroup)this.getContentView();
                int smallerChildOffset = largerOffset;
                int largerChildOffset = smallerOffset;
                for (int i = 0; i < contentView.getChildCount(); ++i) {
                    View item = contentView.getChildAt(i);
                    int itemStartOffset = switch (this.mSnapToAlignment) {
                        case 2 -> item.getTop() - (height - item.getHeight()) / 2;
                        case 1 -> item.getTop();
                        case 3 -> item.getTop() - (height - item.getHeight());
                        default -> throw new IllegalStateException("Invalid SnapToAlignment value: " + this.mSnapToAlignment);
                    };
                    if (itemStartOffset <= targetOffset && targetOffset - itemStartOffset < targetOffset - smallerOffset) {
                        smallerOffset = itemStartOffset;
                    }
                    if (itemStartOffset >= targetOffset && itemStartOffset - targetOffset < largerOffset - targetOffset) {
                        largerOffset = itemStartOffset;
                    }
                    smallerChildOffset = Math.min(smallerChildOffset, itemStartOffset);
                    largerChildOffset = Math.max(largerChildOffset, itemStartOffset);
                }
                smallerOffset = Math.max(smallerOffset, smallerChildOffset);
                largerOffset = Math.min(largerOffset, largerChildOffset);
            }
        } else {
            double interval = this.getSnapInterval();
            double ratio = (double)targetOffset / interval;
            smallerOffset = (int)(Math.floor(ratio) * interval);
            largerOffset = Math.min((int)(Math.ceil(ratio) * interval), maximumOffset);
        }
        int n = nearestOffset = Math.abs(targetOffset - smallerOffset) < Math.abs(largerOffset - targetOffset) ? smallerOffset : largerOffset;
        if (!this.mSnapToEnd && targetOffset >= lastOffset) {
            if (this.getScrollY() < lastOffset) {
                targetOffset = lastOffset;
            }
        } else if (!this.mSnapToStart && targetOffset <= firstOffset) {
            if (this.getScrollY() > firstOffset) {
                targetOffset = firstOffset;
            }
        } else if (velocityY > 0) {
            if (!hasCustomizedFlingAnimator) {
                velocityY += (int)((double)(largerOffset - targetOffset) * 10.0);
            }
            targetOffset = largerOffset;
        } else if (velocityY < 0) {
            if (!hasCustomizedFlingAnimator) {
                velocityY -= (int)((double)(targetOffset - smallerOffset) * 10.0);
            }
            targetOffset = smallerOffset;
        } else {
            targetOffset = nearestOffset;
        }
        targetOffset = Math.min(Math.max(0, targetOffset), maximumOffset);
        if (hasCustomizedFlingAnimator || this.mScroller == null) {
            this.reactSmoothScrollTo(this.getScrollX(), targetOffset);
        } else {
            this.mActivelyScrolling = true;
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), 0, velocityY != 0 ? velocityY : targetOffset - this.getScrollY(), 0, 0, targetOffset, targetOffset, 0, targetOffset == 0 || targetOffset == maximumOffset ? height / 2 : 0);
            this.postInvalidateOnAnimation();
        }
    }

    private int getItemStartOffset(int snapToAlignment, int itemStartPosition, int itemHeight, int viewPortHeight) {
        return switch (snapToAlignment) {
            case 2 -> itemStartPosition - (viewPortHeight - itemHeight) / 2;
            case 1 -> itemStartPosition;
            case 3 -> itemStartPosition - (viewPortHeight - itemHeight);
            default -> throw new IllegalStateException("Invalid SnapToAlignment value: " + this.mSnapToAlignment);
        };
    }

    private int getSnapInterval() {
        if (this.mSnapInterval != 0) {
            return this.mSnapInterval;
        }
        return this.getHeight();
    }

    public void setEndFillColor(int color) {
        if (color != this.mEndFillColor) {
            this.mEndFillColor = color;
            this.mEndBackground = new ColorDrawable(this.mEndFillColor);
        }
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        int scrollRange;
        if (this.mScroller != null && this.mContentView != null && !this.mScroller.isFinished() && this.mScroller.getCurrY() != this.mScroller.getFinalY() && scrollY >= (scrollRange = this.getMaxScrollY())) {
            this.mScroller.abortAnimation();
            scrollY = scrollRange;
        }
        super.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
    }

    public void onChildViewAdded(View parent, View child) {
        this.mContentView = child;
        this.mContentView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    public void onChildViewRemoved(View parent, View child) {
        if (this.mContentView != null) {
            this.mContentView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            this.mContentView = null;
        }
    }

    public void setContentOffset(ReadableMap value) {
        if (this.mCurrentContentOffset == null || !this.mCurrentContentOffset.equals(value)) {
            this.mCurrentContentOffset = value;
            if (value != null) {
                double x = value.hasKey("x") ? value.getDouble("x") : 0.0;
                double y = value.hasKey("y") ? value.getDouble("y") : 0.0;
                this.scrollTo((int)PixelUtil.toPixelFromDIP(x), (int)PixelUtil.toPixelFromDIP(y));
            } else {
                this.scrollTo(0, 0);
            }
        }
    }

    @Override
    public void reactSmoothScrollTo(int x, int y) {
        ReactScrollViewHelper.smoothScrollTo(this, x, y);
        this.setPendingContentOffsets(x, y);
    }

    public void scrollTo(int x, int y) {
        super.scrollTo(x, y);
        ReactScrollViewHelper.updateFabricScrollState(this);
        this.setPendingContentOffsets(x, y);
    }

    private void recreateFlingAnimation(int scrollY) {
        if (this.getFlingAnimator().isRunning()) {
            this.getFlingAnimator().cancel();
        }
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            int scrollerYBeforeTick = this.mScroller.getCurrY();
            boolean hasMoreTicks = this.mScroller.computeScrollOffset();
            this.mScroller.forceFinished(true);
            if (hasMoreTicks) {
                float direction = Math.signum(this.mScroller.getFinalY() - this.mScroller.getStartY());
                float flingVelocityY = this.mScroller.getCurrVelocity() * direction;
                this.mScroller.fling(this.getScrollX(), scrollY, 0, (int)flingVelocityY, 0, 0, 0, Integer.MAX_VALUE);
            } else {
                this.scrollTo(this.getScrollX(), scrollY + (this.mScroller.getCurrX() - scrollerYBeforeTick));
            }
        }
    }

    @Override
    public void scrollToPreservingMomentum(int x, int y) {
        this.scrollTo(x, y);
        this.recreateFlingAnimation(y);
    }

    private boolean isContentReady() {
        View child = this.getContentView();
        return child != null && child.getWidth() != 0 && child.getHeight() != 0;
    }

    private void setPendingContentOffsets(int x, int y) {
        if (this.isContentReady()) {
            this.pendingContentOffsetX = -1;
            this.pendingContentOffsetY = -1;
        } else {
            this.pendingContentOffsetX = x;
            this.pendingContentOffsetY = y;
        }
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        int maxScrollY;
        int currentScrollY;
        if (this.mContentView == null) {
            return;
        }
        if (this.mMaintainVisibleContentPositionHelper != null) {
            this.mMaintainVisibleContentPositionHelper.updateScrollPosition();
        }
        if (this.isShown() && this.isContentReady() && (currentScrollY = this.getScrollY()) > (maxScrollY = this.getMaxScrollY())) {
            this.scrollTo(this.getScrollX(), maxScrollY);
        }
    }

    public void setBackgroundColor(int color) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBackgroundColor((View)this, color);
        } else {
            this.mReactBackgroundManager.setBackgroundColor(color);
        }
    }

    public void setBorderWidth(int position, float width) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBorderWidth((View)this, LogicalEdge.values()[position], Float.valueOf(PixelUtil.toDIPFromPixel(width)));
        } else {
            this.mReactBackgroundManager.setBorderWidth(position, width);
        }
    }

    public void setBorderColor(int position, @Nullable Integer color) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBorderColor((View)this, LogicalEdge.values()[position], color);
        } else {
            this.mReactBackgroundManager.setBorderColor(position, color);
        }
    }

    public void setBorderRadius(float borderRadius) {
        this.setBorderRadius(borderRadius, BorderRadiusProp.BORDER_RADIUS.ordinal());
    }

    public void setBorderRadius(float borderRadius, int position) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(PixelUtil.toDIPFromPixel(borderRadius), LengthPercentageType.POINT);
            BackgroundStyleApplicator.setBorderRadius((View)this, BorderRadiusProp.values()[position], radius);
        } else {
            this.mReactBackgroundManager.setBorderRadius(borderRadius, position);
        }
    }

    public void setBorderStyle(@Nullable String style2) {
        if (ReactNativeFeatureFlags.enableBackgroundStyleApplicator()) {
            BackgroundStyleApplicator.setBorderStyle((View)this, style2 == null ? null : BorderStyle.fromString(style2));
        } else {
            this.mReactBackgroundManager.setBorderStyle(style2);
        }
    }

    public void setScrollAwayTopPaddingEnabledUnstable(int topPadding) {
        int count = this.getChildCount();
        Assertions.assertCondition((count <= 1 ? 1 : 0) != 0, (String)"React Native ScrollView should not have more than one child, it should have exactly 1 child; a content View");
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                View childView = this.getChildAt(i);
                childView.setTranslationY((float)topPadding);
            }
            this.setPadding(0, 0, 0, topPadding);
        }
        this.updateScrollAwayState(topPadding);
        this.setRemoveClippedSubviews(this.mRemoveClippedSubviews);
    }

    private void updateScrollAwayState(int scrollAwayPaddingTop) {
        this.getReactScrollViewScrollState().setScrollAwayPaddingTop(scrollAwayPaddingTop);
        ReactScrollViewHelper.forceUpdateState(this);
    }

    @Override
    public ReactScrollViewHelper.ReactScrollViewScrollState getReactScrollViewScrollState() {
        return this.mReactScrollViewScrollState;
    }

    @Override
    public void startFlingAnimator(int start, int end) {
        this.DEFAULT_FLING_ANIMATOR.cancel();
        this.DEFAULT_FLING_ANIMATOR.setDuration((long)ReactScrollViewHelper.getDefaultScrollAnimationDuration(this.getContext())).setIntValues(new int[]{start, end});
        this.DEFAULT_FLING_ANIMATOR.start();
    }

    @Override
    @NonNull
    public ValueAnimator getFlingAnimator() {
        return this.DEFAULT_FLING_ANIMATOR;
    }

    @Override
    public int getFlingExtrapolatedDistance(int velocityY) {
        return ReactScrollViewHelper.predictFinalScrollPosition(this, (int)0, (int)velocityY, (int)0, (int)this.getMaxScrollY()).y;
    }

    public void setPointerEvents(PointerEvents pointerEvents) {
        this.mPointerEvents = pointerEvents;
    }

    public PointerEvents getPointerEvents() {
        return this.mPointerEvents;
    }

    @Override
    public void setScrollEventThrottle(int scrollEventThrottle) {
        this.mScrollEventThrottle = scrollEventThrottle;
    }

    @Override
    public int getScrollEventThrottle() {
        return this.mScrollEventThrottle;
    }

    @Override
    public void setLastScrollDispatchTime(long lastScrollDispatchTime) {
        this.mLastScrollDispatchTime = lastScrollDispatchTime;
    }

    @Override
    public long getLastScrollDispatchTime() {
        return this.mLastScrollDispatchTime;
    }

    static {
        sTriedToGetScrollerField = false;
    }
}

