/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.icu.text.RuleBasedCollator;
import android.icu.util.ULocale;
import androidx.annotation.RequiresApi;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.IPlatformCollator;
import com.facebook.hermes.intl.JSObjects;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleObjectICU;
import java.util.ArrayList;

public class PlatformCollatorICU
implements IPlatformCollator {
    private RuleBasedCollator mCollator = null;

    PlatformCollatorICU() {
    }

    @Override
    @RequiresApi(api=24)
    public IPlatformCollator configure(ILocaleObject<?> localeObject) throws JSRangeErrorException {
        LocaleObjectICU mLocale = (LocaleObjectICU)localeObject;
        this.mCollator = (RuleBasedCollator)RuleBasedCollator.getInstance((ULocale)mLocale.getLocale());
        this.mCollator.setDecomposition(17);
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public int compare(String source, String target) {
        return this.mCollator.compare(source, target);
    }

    @Override
    @RequiresApi(api=24)
    public IPlatformCollator.Sensitivity getSensitivity() {
        if (this.mCollator == null) {
            return IPlatformCollator.Sensitivity.LOCALE;
        }
        int strength = this.mCollator.getStrength();
        if (strength == 0) {
            if (this.mCollator.isCaseLevel()) {
                return IPlatformCollator.Sensitivity.CASE;
            }
            return IPlatformCollator.Sensitivity.BASE;
        }
        if (strength == 1) {
            return IPlatformCollator.Sensitivity.ACCENT;
        }
        return IPlatformCollator.Sensitivity.VARIANT;
    }

    @Override
    @RequiresApi(api=24)
    public IPlatformCollator setSensitivity(IPlatformCollator.Sensitivity sensitivity) {
        switch (sensitivity) {
            case BASE: {
                this.mCollator.setStrength(0);
                break;
            }
            case ACCENT: {
                this.mCollator.setStrength(1);
                break;
            }
            case CASE: {
                this.mCollator.setStrength(0);
                this.mCollator.setCaseLevel(true);
                break;
            }
            case VARIANT: {
                this.mCollator.setStrength(2);
            }
        }
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public IPlatformCollator setIgnorePunctuation(boolean ignore) {
        if (ignore) {
            this.mCollator.setAlternateHandlingShifted(true);
        }
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public IPlatformCollator setNumericAttribute(boolean numeric) {
        if (numeric) {
            this.mCollator.setNumericCollation(JSObjects.getJavaBoolean(true));
        }
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public IPlatformCollator setCaseFirstAttribute(IPlatformCollator.CaseFirst caseFirst) {
        switch (caseFirst) {
            case UPPER: {
                this.mCollator.setUpperCaseFirst(true);
                break;
            }
            case LOWER: {
                this.mCollator.setLowerCaseFirst(true);
                break;
            }
            default: {
                this.mCollator.setCaseFirstDefault();
            }
        }
        return this;
    }

    @Override
    @RequiresApi(api=24)
    public String[] getAvailableLocales() {
        ULocale[] availableLocales;
        ArrayList<String> availableLocaleIds = new ArrayList<String>();
        for (ULocale locale : availableLocales = ULocale.getAvailableLocales()) {
            availableLocaleIds.add(locale.toLanguageTag());
        }
        String[] availableLocaleIdsArray = new String[availableLocaleIds.size()];
        return availableLocaleIds.toArray(availableLocaleIdsArray);
    }
}

