/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.intl;

import android.icu.util.ULocale;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.facebook.hermes.intl.ILocaleObject;
import com.facebook.hermes.intl.JSRangeErrorException;
import com.facebook.hermes.intl.LocaleObject;
import com.facebook.hermes.intl.LocaleObjectICU;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;

public class LocaleMatcher {
    public static String BestAvailableLocale(String[] availableLocales, String locale) {
        String candidate = locale;
        while (Arrays.asList(availableLocales).indexOf(candidate) <= -1) {
            int pos = candidate.lastIndexOf("-");
            if (pos < 0) {
                return "";
            }
            if (pos >= 2 && candidate.charAt(pos - 2) == '-') {
                pos -= 2;
            }
            candidate = candidate.substring(0, pos);
        }
        return candidate;
    }

    public static LocaleMatchResult lookupMatch(String[] requestedLocales, String[] availableLocales) throws JSRangeErrorException {
        LocaleMatchResult result = new LocaleMatchResult();
        for (String locale : requestedLocales) {
            ILocaleObject requestedLocaleObject = LocaleObject.createFromLocaleId(locale);
            String noExtensionLocale = requestedLocaleObject.toCanonicalTagWithoutExtensions();
            String availableLocale = LocaleMatcher.BestAvailableLocale(availableLocales, noExtensionLocale);
            if (availableLocale.isEmpty()) continue;
            result.matchedLocale = LocaleObject.createFromLocaleId(availableLocale);
            result.extensions = requestedLocaleObject.getUnicodeExtensions();
            return result;
        }
        result.matchedLocale = LocaleObject.createDefault();
        return result;
    }

    public static String[] getAvailableLocales() {
        Locale[] availableLocales;
        if (Build.VERSION.SDK_INT < 21) {
            return new String[]{"en"};
        }
        ArrayList<String> availableLocaleIds = new ArrayList<String>();
        for (Locale locale : availableLocales = Locale.getAvailableLocales()) {
            availableLocaleIds.add(locale.toLanguageTag());
        }
        String[] availableLocaleIdsArray = new String[availableLocaleIds.size()];
        return availableLocaleIds.toArray(availableLocaleIdsArray);
    }

    public static LocaleMatchResult lookupMatch(String[] requestedLocales) throws JSRangeErrorException {
        String[] availableLocales = LocaleMatcher.getAvailableLocales();
        return LocaleMatcher.lookupMatch(requestedLocales, availableLocales);
    }

    public static String[] lookupSupportedLocales(String[] requestedLocales) throws JSRangeErrorException {
        ArrayList<String> subset = new ArrayList<String>();
        String[] availableLocales = LocaleMatcher.getAvailableLocales();
        for (String requestedLocale : requestedLocales) {
            String noExtensionLocale = LocaleObject.createFromLocaleId(requestedLocale).toCanonicalTagWithoutExtensions();
            String availableLocale = LocaleMatcher.BestAvailableLocale(availableLocales, noExtensionLocale);
            if (availableLocale == null || availableLocale.isEmpty()) continue;
            subset.add(requestedLocale);
        }
        String[] subsetArray = new String[subset.size()];
        return subset.toArray(subsetArray);
    }

    @RequiresApi(api=24)
    public static ULocale bestFitBestAvailableLocale(ILocaleObject<?> requestedLocaleObject) throws JSRangeErrorException {
        ULocale[] availableLocales = ULocale.getAvailableLocales();
        ULocale requestedULocaleWithoutExtensions = (ULocale)requestedLocaleObject.getLocaleWithoutExtensions();
        ULocale[] requestedLocalesArray = new ULocale[]{requestedULocaleWithoutExtensions};
        boolean[] fallback = new boolean[1];
        ULocale acceptedLocale = ULocale.acceptLanguage((ULocale[])requestedLocalesArray, (ULocale[])availableLocales, (boolean[])fallback);
        if (!fallback[0] && acceptedLocale != null) {
            return acceptedLocale;
        }
        return null;
    }

    @RequiresApi(api=24)
    public static LocaleMatchResult bestFitMatch(String[] requestedLocales) throws JSRangeErrorException {
        LocaleMatchResult result = new LocaleMatchResult();
        for (String requestedLocale : requestedLocales) {
            ILocaleObject requestedLocaleObject = LocaleObject.createFromLocaleId(requestedLocale);
            ULocale availableLocale = LocaleMatcher.bestFitBestAvailableLocale(requestedLocaleObject);
            if (availableLocale == null) continue;
            result.matchedLocale = LocaleObjectICU.createFromULocale(availableLocale);
            result.extensions = requestedLocaleObject.getUnicodeExtensions();
            return result;
        }
        result.matchedLocale = LocaleObjectICU.createDefault();
        return result;
    }

    @RequiresApi(api=24)
    public static String[] bestFitSupportedLocales(String[] requestedLocales) throws JSRangeErrorException {
        ArrayList<String> subset = new ArrayList<String>();
        for (String requestedLocale : requestedLocales) {
            ULocale uLocale = LocaleMatcher.bestFitBestAvailableLocale(LocaleObject.createFromLocaleId(requestedLocale));
            if (uLocale == null) continue;
            subset.add(requestedLocale);
        }
        String[] subsetArray = new String[subset.size()];
        return subset.toArray(subsetArray);
    }

    public static class LocaleMatchResult {
        public ILocaleObject<?> matchedLocale;
        public HashMap<String, String> extensions = new HashMap();
    }
}

