/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.sqlserver;

import com.facebook.presto.plugin.jdbc.BaseJdbcClient;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.ConnectionFactory;
import com.facebook.presto.plugin.jdbc.DriverConnectionFactory;
import com.facebook.presto.plugin.jdbc.JdbcConnectorId;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.plugin.jdbc.JdbcOutputTableHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import javax.inject.Inject;

public class SqlServerClient
extends BaseJdbcClient {
    @Inject
    public SqlServerClient(JdbcConnectorId connectorId, BaseJdbcConfig config) throws SQLException {
        super(connectorId, config, "\"", (ConnectionFactory)new DriverConnectionFactory((Driver)new SQLServerDriver(), config));
    }

    public void commitCreateTable(JdbcOutputTableHandle handle) {
        StringBuilder sql = new StringBuilder().append("sp_rename ").append(SqlServerClient.singleQuote(handle.getCatalogName(), handle.getSchemaName(), handle.getTemporaryTableName())).append(", ").append(SqlServerClient.singleQuote(handle.getTableName()));
        try (Connection connection = this.getConnection(handle);){
            this.execute(connection, sql.toString());
        }
        catch (SQLException e) {
            throw new PrestoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static String singleQuote(String catalog, String schema, String table) {
        return SqlServerClient.singleQuote(catalog + "." + schema + "." + table);
    }

    private static String singleQuote(String literal) {
        return "'" + literal + "'";
    }
}

