/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.scalar.sql;

import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.SqlInvokedScalarFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;

public class ArrayIntersectFunction {
    private ArrayIntersectFunction() {
    }

    @SqlInvokedScalarFunction(value="array_intersect", deterministic=true, calledOnNullInput=false)
    @Description(value="Intersects elements of all arrays in the given array")
    @TypeParameter(value="T")
    @SqlParameter(name="input", type="array<array<T>>")
    @SqlType(value="array<T>")
    public static String arrayIntersectArray() {
        return "RETURN reduce(input, IF((cardinality(input) = 0), ARRAY[], input[1]), (s, x) -> array_intersect(s, x), (s) -> s)";
    }
}

