/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.spark.Partition;
import org.apache.spark.shuffle.ShuffleHandle;

public class PrestoSparkShuffleReadDescriptor {
    private final Partition partition;
    private final ShuffleHandle shuffleHandle;
    private final List<String> blockIds;
    private final List<String> partitionIds;
    private final List<Long> partitionSizes;
    private final int numPartitions;

    public PrestoSparkShuffleReadDescriptor(Partition partition, ShuffleHandle shuffleHandle, int numPartitions, List<String> blockIds, List<String> partitionIds, List<Long> partitionSizes) {
        this.partition = Objects.requireNonNull(partition, "partition is null");
        this.shuffleHandle = Objects.requireNonNull(shuffleHandle, "shuffleHandle is null");
        this.blockIds = Objects.requireNonNull(blockIds, "blockIds is null");
        this.partitionIds = Objects.requireNonNull(partitionIds, "partitionIds is null");
        this.partitionSizes = Objects.requireNonNull(partitionSizes, "partitionSizes is null");
        Preconditions.checkArgument((numPartitions > 0 ? 1 : 0) != 0, (Object)"numPartitions requires larger than 0");
        this.numPartitions = numPartitions;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public List<String> getBlockIds() {
        return this.blockIds;
    }

    public List<String> getPartitionIds() {
        return this.partitionIds;
    }

    public List<Long> getPartitionSizes() {
        return this.partitionSizes;
    }

    public ShuffleHandle getShuffleHandle() {
        return this.shuffleHandle;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }
}

