/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import com.facebook.presto.spark.classloader_interface.PrestoSparkMutableRow;
import com.facebook.presto.spark.classloader_interface.PrestoSparkSerializedPage;
import com.facebook.presto.spark.classloader_interface.PrestoSparkShuffleStats;
import com.facebook.presto.spark.classloader_interface.PrestoSparkStorageHandle;
import com.facebook.presto.spark.classloader_interface.SerializedPrestoSparkTaskDescriptor;
import com.facebook.presto.spark.classloader_interface.SerializedPrestoSparkTaskSource;
import com.facebook.presto.spark.classloader_interface.SerializedTaskInfo;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;

public class PrestoSparkConfInitializer {
    private static final String INITIALIZED_MARKER = "presto.spark.conf.initialized";

    private PrestoSparkConfInitializer() {
    }

    public static void initialize(SparkConf sparkConf) {
        if (sparkConf.get(INITIALIZED_MARKER, null) != null) {
            throw new IllegalArgumentException("SparkConf is already initialized");
        }
        PrestoSparkConfInitializer.registerKryoClasses(sparkConf);
        sparkConf.set(INITIALIZED_MARKER, "true");
    }

    private static void registerKryoClasses(SparkConf sparkConf) {
        sparkConf.registerKryoClasses(new Class[]{MutablePartitionId.class, PrestoSparkMutableRow.class, PrestoSparkSerializedPage.class, SerializedPrestoSparkTaskDescriptor.class, SerializedTaskInfo.class, PrestoSparkShuffleStats.class, PrestoSparkStorageHandle.class, SerializedPrestoSparkTaskSource.class});
    }

    public static void checkInitialized(SparkContext sparkContext) {
        SparkConf sparkConf = sparkContext.getConf();
        if (sparkConf.get(INITIALIZED_MARKER, null) == null) {
            throw new IllegalArgumentException("SparkConf must be initialized with PrestoSparkConfInitializer.initialize before creating SparkContext");
        }
    }
}

