/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import com.facebook.presto.spark.classloader_interface.MutablePartitionId;
import java.util.Objects;
import org.apache.spark.Partitioner;

public class PrestoSparkPartitioner
extends Partitioner {
    private final int numPartitions;

    public PrestoSparkPartitioner(int numPartitions) {
        this.numPartitions = numPartitions;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int getPartition(Object key) {
        Objects.requireNonNull(key, "key is null");
        MutablePartitionId mutablePartitionId = (MutablePartitionId)key;
        int partition = mutablePartitionId.getPartition();
        if (partition < 0 || partition >= this.numPartitions) {
            throw new IllegalArgumentException(String.format("Unexpected partition: %s. Total number of partitions: %s.", partition, this.numPartitions));
        }
        return partition;
    }
}

