/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spark.classloader_interface;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PrestoSparkSession {
    private final String user;
    private final Optional<Principal> principal;
    private final Map<String, String> extraCredentials;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final Optional<String> source;
    private final Optional<String> clientInfo;
    private final Set<String> clientTags;
    private final Optional<String> timeZoneId;
    private final Optional<String> language;
    private final Map<String, String> systemProperties;
    private final Map<String, Map<String, String>> catalogSessionProperties;
    private final Optional<String> traceToken;

    public PrestoSparkSession(String user, Optional<Principal> principal, Map<String, String> extraCredentials, Optional<String> catalog, Optional<String> schema, Optional<String> source, Optional<String> clientInfo, Set<String> clientTags, Optional<String> timeZoneId, Optional<String> language, Map<String, String> systemProperties, Map<String, Map<String, String>> catalogSessionProperties, Optional<String> traceToken) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.principal = Objects.requireNonNull(principal, "principal is null");
        this.extraCredentials = Collections.unmodifiableMap(new HashMap<String, String>(Objects.requireNonNull(extraCredentials, "extraCredentials is null")));
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.source = Objects.requireNonNull(source, "source is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.clientTags = Collections.unmodifiableSet(new HashSet(Objects.requireNonNull(clientTags, "clientTags is null")));
        this.timeZoneId = Objects.requireNonNull(timeZoneId, "timeZoneId is null");
        this.language = Objects.requireNonNull(language, "language is null");
        this.systemProperties = Collections.unmodifiableMap(new HashMap<String, String>(Objects.requireNonNull(systemProperties, "systemProperties is null")));
        this.catalogSessionProperties = Collections.unmodifiableMap(Objects.requireNonNull(catalogSessionProperties, "catalogSessionProperties is null").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableMap(new HashMap((Map)entry.getValue())))));
        this.traceToken = Objects.requireNonNull(traceToken, "traceToken is null");
    }

    public String getUser() {
        return this.user;
    }

    public Optional<Principal> getPrincipal() {
        return this.principal;
    }

    public Map<String, String> getExtraCredentials() {
        return this.extraCredentials;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    public Set<String> getClientTags() {
        return this.clientTags;
    }

    public Optional<String> getTimeZoneId() {
        return this.timeZoneId;
    }

    public Optional<String> getLanguage() {
        return this.language;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, Map<String, String>> getCatalogSessionProperties() {
        return this.catalogSessionProperties;
    }

    public Optional<String> getTraceToken() {
        return this.traceToken;
    }
}

