/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.spec;

import com.facebook.presto.router.cluster.RequestInfo;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SelectorRuleSpec {
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> sourceRegex;
    private final Optional<List<String>> clientTags;
    private final String targetGroup;

    @JsonCreator
    public SelectorRuleSpec(@JsonProperty(value="source") Optional<Pattern> sourceRegex, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="clientTags") Optional<List<String>> clientTags, @JsonProperty(value="targetGroup") String targetGroup) {
        this.sourceRegex = Objects.requireNonNull(sourceRegex, "sourceRegex is null");
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.clientTags = Objects.requireNonNull(clientTags, "clientTags is null");
        this.targetGroup = Objects.requireNonNull(targetGroup, "targetGroup is null");
    }

    @JsonProperty
    public Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    @JsonProperty
    public Optional<Pattern> getSourceRegex() {
        return this.sourceRegex;
    }

    @JsonProperty
    public Optional<List<String>> getClientTags() {
        return this.clientTags;
    }

    @JsonProperty
    public String getTargetGroup() {
        return this.targetGroup;
    }

    public Optional<String> match(RequestInfo requestInfo) {
        Matcher userMatcher;
        if (this.userRegex.isPresent() && !(userMatcher = this.userRegex.get().matcher(requestInfo.getUser())).matches()) {
            return Optional.empty();
        }
        if (this.sourceRegex.isPresent()) {
            String source = requestInfo.getSource().orElse("");
            if (!this.sourceRegex.get().matcher(source).matches()) {
                return Optional.empty();
            }
        }
        if (this.clientTags.isPresent() && requestInfo.getClientTags().containsAll((Collection)this.clientTags.get())) {
            return Optional.empty();
        }
        return Optional.of(this.targetGroup);
    }
}

