/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.spec;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.router.scheduler.SchedulerType;
import com.facebook.presto.router.spec.GroupSpec;
import com.facebook.presto.router.spec.SelectorRuleSpec;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RouterSpec {
    private final List<GroupSpec> groups;
    private final List<SelectorRuleSpec> selectors;
    private final Optional<SchedulerType> schedulerType;
    private final Optional<URI> predictorUri;
    private static final Logger log = Logger.get(RouterSpec.class);

    @JsonCreator
    public RouterSpec(@JsonProperty(value="groups") List<GroupSpec> groups, @JsonProperty(value="selectors") List<SelectorRuleSpec> selectors, @JsonProperty(value="scheduler") Optional<SchedulerType> schedulerType, @JsonProperty(value="predictor") Optional<URI> predictorUri) {
        this.groups = ImmutableList.copyOf((Collection)Objects.requireNonNull(groups, "groups is null"));
        this.selectors = ImmutableList.copyOf((Collection)Objects.requireNonNull(selectors, "selectors is null"));
        this.schedulerType = Objects.requireNonNull(schedulerType, "scheduleType is null");
        this.predictorUri = Objects.requireNonNull(predictorUri, "predictorUri is null");
        Preconditions.checkArgument((boolean)groups.stream().map(GroupSpec::getName).allMatch(new HashSet()::add));
    }

    @JsonProperty
    public List<GroupSpec> getGroups() {
        return this.groups;
    }

    @JsonProperty
    public List<SelectorRuleSpec> getSelectors() {
        return this.selectors;
    }

    @JsonProperty
    public SchedulerType getSchedulerType() {
        return this.schedulerType.orElse(SchedulerType.RANDOM_CHOICE);
    }

    @JsonProperty
    public Optional<URI> getPredictorUri() {
        try {
            return Optional.of(this.predictorUri.orElse(new URI("http://127.0.0.1:8000/v1")));
        }
        catch (URISyntaxException e) {
            log.error("Error in getting the predictor's URI");
            return Optional.empty();
        }
    }
}

