/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.spec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class GroupSpec {
    private final String name;
    private final List<URI> members;
    private final Optional<List<Integer>> weights;

    @JsonCreator
    public GroupSpec(@JsonProperty(value="name") String name, @JsonProperty(value="members") List<URI> members, @JsonProperty(value="weights") Optional<List<Integer>> weights) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.members = ImmutableList.copyOf((Collection)Objects.requireNonNull(members, "members is null"));
        this.weights = Objects.requireNonNull(weights, "weights is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public List<URI> getMembers() {
        return this.members;
    }

    @JsonProperty
    public List<Integer> getWeights() {
        return this.weights.orElseGet(() -> new ArrayList<Integer>(Collections.nCopies(this.members.size(), 1)));
    }
}

