/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.scheduler;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.router.scheduler.Scheduler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class WeightedRandomChoiceScheduler
implements Scheduler {
    private List<URI> candidates;
    private HashMap<URI, Integer> weights;
    private static final Random RANDOM = new Random();
    private static final Logger log = Logger.get(WeightedRandomChoiceScheduler.class);

    @Override
    public Optional<URI> getDestination(String user) {
        Preconditions.checkArgument((this.candidates.size() == this.weights.size() ? 1 : 0) != 0);
        try {
            List serverList = (List)this.weights.keySet().stream().map(uri -> Collections.nCopies(this.weights.get(uri), uri)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
            return Optional.of(serverList.get(RANDOM.nextInt(serverList.size())));
        }
        catch (IllegalArgumentException e) {
            log.warn((Throwable)e, "Error getting destination for user " + user);
            return Optional.empty();
        }
    }

    @Override
    public void setCandidates(List<URI> candidates) {
        this.candidates = candidates;
    }

    public List<URI> getCandidates() {
        return this.candidates;
    }

    @Override
    public void setWeights(HashMap<URI, Integer> weights) {
        this.weights = weights;
    }

    public HashMap<URI, Integer> getWeights() {
        return this.weights;
    }
}

