/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.scheduler;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.router.scheduler.Scheduler;
import java.net.URI;
import java.util.List;
import java.util.Optional;

public class UserHashScheduler
implements Scheduler {
    private List<URI> candidates;
    private static final Logger log = Logger.get(UserHashScheduler.class);

    @Override
    public Optional<URI> getDestination(String user) {
        try {
            return Optional.of(this.candidates.get(user.hashCode() % this.candidates.size()));
        }
        catch (ArithmeticException e) {
            log.warn((Throwable)e, "Error getting destination for user " + user);
            return Optional.empty();
        }
    }

    @Override
    public void setCandidates(List<URI> candidates) {
        this.candidates = candidates;
    }

    public List<URI> getCandidates() {
        return this.candidates;
    }
}

