/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.scheduler;

import com.facebook.presto.router.scheduler.RandomChoiceScheduler;
import com.facebook.presto.router.scheduler.RoundRobinScheduler;
import com.facebook.presto.router.scheduler.Scheduler;
import com.facebook.presto.router.scheduler.SchedulerType;
import com.facebook.presto.router.scheduler.UserHashScheduler;
import com.facebook.presto.router.scheduler.WeightedRandomChoiceScheduler;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.util.Objects;

public class SchedulerFactory {
    private final SchedulerType schedulerType;

    public SchedulerFactory(SchedulerType schedulerType) {
        this.schedulerType = Objects.requireNonNull(schedulerType, "schedulerType is null");
    }

    public Scheduler create() {
        switch (this.schedulerType) {
            case RANDOM_CHOICE: {
                return new RandomChoiceScheduler();
            }
            case WEIGHTED_RANDOM_CHOICE: {
                return new WeightedRandomChoiceScheduler();
            }
            case USER_HASH: {
                return new UserHashScheduler();
            }
            case ROUND_ROBIN: {
                return new RoundRobinScheduler();
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported router scheduler type " + (Object)((Object)this.schedulerType));
    }
}

