/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.predictor;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.router.predictor.MemoryInfo;
import com.facebook.presto.router.predictor.RemoteQuery;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RemoteQueryMemory
extends RemoteQuery {
    private static final Logger log = Logger.get(RemoteQueryMemory.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String MEMORY_BYTES_LABEL = "memory_pred_label";
    private static final String MEMORY_BYTES_STR = "memory_pred_str";
    private MemoryInfo memoryInfo;

    public RemoteQueryMemory(HttpClient httpClient, URI remoteUri) {
        super(httpClient, remoteUri);
    }

    @Override
    public void handleResponse(JsonNode response) {
        try {
            Map fields = (Map)mapper.convertValue((Object)response, Map.class);
            if (fields.containsKey("status") && ((Integer)fields.get("status")).intValue() != HttpStatus.OK.code()) {
                this.memoryInfo = null;
                return;
            }
            this.memoryInfo = new MemoryInfo((Integer)fields.get(MEMORY_BYTES_LABEL), (String)fields.get(MEMORY_BYTES_STR));
        }
        catch (Exception e) {
            log.error("Error handling response: %s", new Object[]{response.toString()});
        }
    }

    public MemoryInfo getMemoryInfo() {
        return this.memoryInfo;
    }
}

