/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.predictor;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.presto.router.predictor.ForQueryCpuPredictor;
import com.facebook.presto.router.predictor.ForQueryMemoryPredictor;
import com.facebook.presto.router.predictor.RemoteQueryCpu;
import com.facebook.presto.router.predictor.RemoteQueryMemory;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;

public class RemoteQueryFactory {
    private static final String QUERY_CPU_URI = "/cpu";
    private static final String QUERY_MEMORY_URI = "/memory";
    private final HttpClient queryCpuHttpClient;
    private final HttpClient queryMemoryHttpClient;

    @Inject
    public RemoteQueryFactory(@ForQueryCpuPredictor HttpClient queryCpuHttpClient, @ForQueryMemoryPredictor HttpClient queryMemoryHttpClient) {
        this.queryCpuHttpClient = Objects.requireNonNull(queryCpuHttpClient, "Http client for CPU prediction is null");
        this.queryMemoryHttpClient = Objects.requireNonNull(queryMemoryHttpClient, "Http client for memory prediction is null");
    }

    public RemoteQueryCpu createRemoteQueryCPU(URI uri) {
        return new RemoteQueryCpu(this.queryCpuHttpClient, HttpUriBuilder.uriBuilderFrom((URI)uri).appendPath(QUERY_CPU_URI).build());
    }

    public RemoteQueryMemory createRemoteQueryMemory(URI uri) {
        return new RemoteQueryMemory(this.queryMemoryHttpClient, HttpUriBuilder.uriBuilderFrom((URI)uri).appendPath(QUERY_MEMORY_URI).build());
    }
}

