/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.predictor;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.router.predictor.CpuInfo;
import com.facebook.presto.router.predictor.RemoteQuery;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RemoteQueryCpu
extends RemoteQuery {
    private static final Logger log = Logger.get(RemoteQueryCpu.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String CPU_TIME_LABEL = "cpu_pred_label";
    private static final String CPU_TIME_STR = "cpu_pred_str";
    private CpuInfo cpuInfo;

    public RemoteQueryCpu(HttpClient httpClient, URI remoteUri) {
        super(httpClient, remoteUri);
    }

    @Override
    public void handleResponse(JsonNode response) {
        try {
            Map fields = (Map)mapper.convertValue((Object)response, Map.class);
            if (fields.containsKey("status") && ((Integer)fields.get("status")).intValue() != HttpStatus.OK.code()) {
                this.cpuInfo = null;
                return;
            }
            this.cpuInfo = new CpuInfo((Integer)fields.get(CPU_TIME_LABEL), (String)fields.get(CPU_TIME_STR));
        }
        catch (Exception e) {
            log.error("Error handling response: %s", new Object[]{response.toString()});
        }
    }

    public CpuInfo getCpuInfo() {
        return this.cpuInfo;
    }
}

