/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.predictor;

import com.facebook.airlift.http.client.BodyGenerator;
import com.facebook.airlift.http.client.FullJsonResponseHandler;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.http.client.StaticBodyGenerator;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class RemoteQuery {
    private static final Logger log = Logger.get(RemoteQuery.class);
    private static final JsonCodec<JsonNode> JSON_CODEC = JsonCodec.jsonCodec(JsonNode.class);
    private final HttpClient httpClient;
    private final URI remoteUri;

    public RemoteQuery(HttpClient httpClient, URI remoteUri) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.remoteUri = Objects.requireNonNull(remoteUri, "remoteUri is null");
    }

    public synchronized void execute(String statement) {
        JsonCodec jsonCodec = JsonCodec.mapJsonCodec(String.class, String.class);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("query", statement);
        String body = jsonCodec.toJson(queryMap);
        log.info("Sending request to %s", new Object[]{this.remoteUri});
        Request request = Request.Builder.preparePost().setUri(this.remoteUri).addHeader("Content-Type", "application/json").setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)body, (Charset)StandardCharsets.UTF_8)).build();
        FullJsonResponseHandler.JsonResponse result = (FullJsonResponseHandler.JsonResponse)this.httpClient.execute(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(JSON_CODEC));
        log.info("Received response from %s", new Object[]{this.remoteUri});
        if (result != null) {
            if (result.getStatusCode() != HttpStatus.OK.code()) {
                log.error("Error fetching info from %s returned status %d: %s", new Object[]{this.remoteUri, result.getStatusCode(), result.getStatusMessage()});
            }
            if (result.hasValue()) {
                this.handleResponse((JsonNode)result.getValue());
            }
        } else {
            log.error("Error fetching request");
        }
    }

    public abstract void handleResponse(JsonNode var1);
}

