/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.predictor;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.router.RouterConfig;
import com.facebook.presto.router.RouterUtil;
import com.facebook.presto.router.predictor.CpuInfo;
import com.facebook.presto.router.predictor.MemoryInfo;
import com.facebook.presto.router.predictor.RemoteQueryCpu;
import com.facebook.presto.router.predictor.RemoteQueryFactory;
import com.facebook.presto.router.predictor.RemoteQueryMemory;
import com.facebook.presto.router.predictor.ResourceGroup;
import com.facebook.presto.router.spec.RouterSpec;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;

public class PredictorManager {
    private static final Logger log = Logger.get(PredictorManager.class);
    private final RemoteQueryFactory remoteQueryFactory;
    private final URI uri;

    @Inject
    public PredictorManager(RemoteQueryFactory remoteQueryFactory, RouterConfig config) {
        RouterSpec routerSpec = RouterUtil.parseRouterConfig(config).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "Failed to load router config"));
        this.remoteQueryFactory = Objects.requireNonNull(remoteQueryFactory, "");
        this.uri = routerSpec.getPredictorUri().orElse(null);
    }

    public Optional<ResourceGroup> fetchPrediction(String statement) {
        try {
            return Optional.of(new ResourceGroup(this.fetchCpuPrediction(statement).orElse(null), this.fetchMemoryPrediction(statement).orElse(null)));
        }
        catch (Exception e) {
            log.error("Error in fetching prediction", new Object[]{e});
            return Optional.empty();
        }
    }

    public Optional<ResourceGroup> fetchPredictionParallel(String statement) {
        ExecutorService executor = Executors.newCachedThreadPool();
        Future<CpuInfo> cpuInfoFuture = executor.submit(() -> this.fetchCpuPrediction(statement).orElse(null));
        Future<MemoryInfo> memoryInfoFuture = executor.submit(() -> this.fetchMemoryPrediction(statement).orElse(null));
        try {
            return Optional.of(new ResourceGroup(cpuInfoFuture.get(), memoryInfoFuture.get()));
        }
        catch (Exception e) {
            log.error("Error in fetching prediction in parallel", new Object[]{e});
            return Optional.empty();
        }
    }

    public Optional<CpuInfo> fetchCpuPrediction(String statement) {
        try {
            RemoteQueryCpu remoteQueryCpu = this.remoteQueryFactory.createRemoteQueryCPU(this.uri);
            remoteQueryCpu.execute(statement);
            return Optional.of(remoteQueryCpu.getCpuInfo());
        }
        catch (Exception e) {
            log.error("Error in fetching CPU prediction", new Object[]{e});
            return Optional.empty();
        }
    }

    public Optional<MemoryInfo> fetchMemoryPrediction(String statement) {
        try {
            RemoteQueryMemory remoteQueryMemory = this.remoteQueryFactory.createRemoteQueryMemory(this.uri);
            remoteQueryMemory.execute(statement);
            return Optional.of(remoteQueryMemory.getMemoryInfo());
        }
        catch (Exception e) {
            log.error("Error in fetching memory prediction", new Object[]{e});
            return Optional.empty();
        }
    }
}

