/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.cluster;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class RequestInfo {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final String user;
    private final Optional<String> source;
    private final List<String> clientTags;

    public RequestInfo(HttpServletRequest servletRequest, String query) {
        this.user = RequestInfo.parseHeader(servletRequest, "X-Presto-User");
        this.source = Optional.ofNullable(RequestInfo.parseHeader(servletRequest, "X-Presto-Source"));
        this.clientTags = Objects.requireNonNull(RequestInfo.parseClientTags(servletRequest), "clientTags is null");
    }

    public String getUser() {
        return this.user;
    }

    public Optional<String> getSource() {
        return this.source;
    }

    public List<String> getClientTags() {
        return this.clientTags;
    }

    private static List<String> parseClientTags(HttpServletRequest servletRequest) {
        return ImmutableList.copyOf((Iterable)SPLITTER.split((CharSequence)Strings.nullToEmpty((String)servletRequest.getHeader("X-Presto-Client-Tags"))));
    }

    private static String parseHeader(HttpServletRequest servletRequest, String header) {
        return RequestInfo.trimEmptyToNull(servletRequest.getHeader(header));
    }

    private static String trimEmptyToNull(String value) {
        return Strings.emptyToNull((String)Strings.nullToEmpty((String)value).trim());
    }
}

