/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.cluster;

import com.facebook.airlift.http.client.FullJsonResponseHandler;
import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpStatus;
import com.facebook.airlift.http.client.Request;
import com.facebook.airlift.http.client.ResponseHandler;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.log.Logger;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class RemoteState {
    private static final Logger log = Logger.get(RemoteState.class);
    private static final JsonCodec<JsonNode> JSON_CODEC = JsonCodec.jsonCodec(JsonNode.class);
    private final HttpClient httpClient;
    private final URI remoteUri;
    private final AtomicReference<Future<?>> future = new AtomicReference();
    private final AtomicLong lastUpdateNanos = new AtomicLong();
    private final AtomicLong lastWarningLogged = new AtomicLong();

    public RemoteState(HttpClient httpClient, URI remoteUri) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.remoteUri = Objects.requireNonNull(remoteUri, "remoteUri is null");
    }

    public void handleResponse(JsonNode response) {
    }

    public synchronized void asyncRefresh() {
        Duration sinceUpdate = Duration.nanosSince((long)this.lastUpdateNanos.get());
        if (Duration.nanosSince((long)this.lastWarningLogged.get()).toMillis() > 1000L && sinceUpdate.toMillis() > 10000L && this.future.get() != null) {
            log.warn("Coordinator update request to %s has not returned in %s", new Object[]{this.remoteUri, sinceUpdate.toString(TimeUnit.SECONDS)});
            this.lastWarningLogged.set(System.nanoTime());
        }
        if (sinceUpdate.toMillis() > 1000L && this.future.get() == null) {
            Request request = Request.Builder.prepareGet().setUri(this.remoteUri).build();
            final HttpClient.HttpResponseFuture responseFuture = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(JSON_CODEC));
            this.future.compareAndSet((Future<?>)null, (Future<?>)responseFuture);
            Futures.addCallback((ListenableFuture)responseFuture, (FutureCallback)new FutureCallback<FullJsonResponseHandler.JsonResponse<JsonNode>>(){

                public void onSuccess(@Nullable FullJsonResponseHandler.JsonResponse<JsonNode> result) {
                    RemoteState.this.lastUpdateNanos.set(System.nanoTime());
                    RemoteState.this.future.compareAndSet(responseFuture, null);
                    if (result != null) {
                        if (result.hasValue()) {
                            RemoteState.this.handleResponse((JsonNode)result.getValue());
                        }
                        if (result.getStatusCode() != HttpStatus.OK.code()) {
                            log.warn("Error fetching node state from %s returned status %d: %s", new Object[]{RemoteState.this.remoteUri, result.getStatusCode(), result.getStatusMessage()});
                            return;
                        }
                    }
                }

                public void onFailure(Throwable t) {
                    log.warn("Error fetching query infos from %s: %s", new Object[]{RemoteState.this.remoteUri, t.getMessage()});
                    RemoteState.this.lastUpdateNanos.set(System.nanoTime());
                    RemoteState.this.future.compareAndSet(responseFuture, null);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }
}

