/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.cluster;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.router.cluster.RemoteState;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RemoteQueryInfo
extends RemoteState {
    private static final Logger log = Logger.get(RemoteQueryInfo.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final AtomicReference<Optional<List<JsonNode>>> queryList = new AtomicReference(Optional.empty());

    public RemoteQueryInfo(HttpClient httpClient, URI remoteUri) {
        super(httpClient, remoteUri);
    }

    public Optional<List<JsonNode>> getQueryList() {
        return this.queryList.get();
    }

    @Override
    public void handleResponse(JsonNode response) {
        ObjectReader reader = mapper.readerFor((TypeReference)new TypeReference<List<JsonNode>>(){});
        try {
            this.queryList.set(Optional.ofNullable(reader.readValue(response)));
        }
        catch (IOException e) {
            log.warn("Error parsing response: %s", new Object[]{response.toString()});
        }
    }
}

