/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.cluster;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.presto.router.cluster.ForClusterInfoTracker;
import com.facebook.presto.router.cluster.ForQueryInfoTracker;
import com.facebook.presto.router.cluster.RemoteClusterInfo;
import com.facebook.presto.router.cluster.RemoteQueryInfo;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;

public class RemoteInfoFactory {
    private static final String QUERY_INFO = "/v1/query";
    private static final String CLUSTER_INFO = "/v1/cluster";
    private final HttpClient clusterInfoHttpClient;
    private final HttpClient queryInfoHttpClient;

    @Inject
    public RemoteInfoFactory(@ForClusterInfoTracker HttpClient clusterInfoHttpClient, @ForQueryInfoTracker HttpClient queryInfoHttpClient) {
        this.clusterInfoHttpClient = Objects.requireNonNull(clusterInfoHttpClient, "Http client for cluster info is null");
        this.queryInfoHttpClient = Objects.requireNonNull(queryInfoHttpClient, "Http client for cluster info is null");
    }

    public RemoteQueryInfo createRemoteQueryInfo(URI uri) {
        return new RemoteQueryInfo(this.clusterInfoHttpClient, HttpUriBuilder.uriBuilderFrom((URI)uri).appendPath(QUERY_INFO).build());
    }

    public RemoteClusterInfo createRemoteClusterInfo(URI uri) {
        return new RemoteClusterInfo(this.queryInfoHttpClient, HttpUriBuilder.uriBuilderFrom((URI)uri).appendPath(CLUSTER_INFO).build());
    }
}

