/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.cluster;

import com.facebook.airlift.http.client.HttpClient;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.router.cluster.RemoteState;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class RemoteClusterInfo
extends RemoteState {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = Logger.get(RemoteClusterInfo.class);
    private static final String RUNNING_QUERIES = "runningQueries";
    private static final String BLOCKED_QUERIES = "blockedQueries";
    private static final String QUEUED_QUERIES = "queuedQueries";
    private static final String ACTIVE_WORKERS = "activeWorkers";
    private static final String RUNNING_DRIVERS = "runningDrivers";
    private final AtomicLong runningQueries = new AtomicLong();
    private final AtomicLong blockedQueries = new AtomicLong();
    private final AtomicLong queuedQueries = new AtomicLong();
    private final AtomicLong activeWorkers = new AtomicLong();
    private final AtomicLong runningDrivers = new AtomicLong();

    public RemoteClusterInfo(HttpClient httpClient, URI remoteUri) {
        super(httpClient, remoteUri);
    }

    @Override
    public void handleResponse(JsonNode response) {
        Map fields = (Map)mapper.convertValue((Object)response, Map.class);
        this.runningQueries.set(((Integer)fields.get(RUNNING_QUERIES)).intValue());
        this.blockedQueries.set(((Integer)fields.get(BLOCKED_QUERIES)).intValue());
        this.queuedQueries.set(((Integer)fields.get(QUEUED_QUERIES)).intValue());
        this.activeWorkers.set(((Integer)fields.get(ACTIVE_WORKERS)).intValue());
        this.runningDrivers.set(((Integer)fields.get(RUNNING_DRIVERS)).intValue());
    }

    public long getRunningQueries() {
        return this.runningQueries.get();
    }

    public long getBlockedQueries() {
        return this.blockedQueries.get();
    }

    public long getQueuedQueries() {
        return this.queuedQueries.get();
    }

    public long getActiveWorkers() {
        return this.activeWorkers.get();
    }

    public long getRunningDrivers() {
        return this.runningDrivers.get();
    }
}

