/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.cluster;

import com.facebook.airlift.concurrent.Threads;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.router.cluster.ClusterManager;
import com.facebook.presto.router.cluster.RemoteClusterInfo;
import com.facebook.presto.router.cluster.RemoteInfoFactory;
import com.facebook.presto.router.cluster.RemoteQueryInfo;
import com.facebook.presto.router.cluster.RemoteState;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;

public class ClusterStatusTracker {
    private static final Logger log = Logger.get(ClusterStatusTracker.class);
    private final ClusterManager clusterManager;
    private final RemoteInfoFactory remoteInfoFactory;
    private final ScheduledExecutorService queryInfoUpdateExecutor;
    private final ConcurrentHashMap<URI, RemoteClusterInfo> remoteClusterInfos = new ConcurrentHashMap();
    private final ConcurrentHashMap<URI, RemoteQueryInfo> remoteQueryInfos = new ConcurrentHashMap();

    @Inject
    public ClusterStatusTracker(ClusterManager clusterManager, RemoteInfoFactory remoteInfoFactory) {
        this.clusterManager = Objects.requireNonNull(clusterManager, "clusterManager is null");
        this.remoteInfoFactory = Objects.requireNonNull(remoteInfoFactory, "remoteInfoFactory is null");
        this.queryInfoUpdateExecutor = Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"query-info-poller-%s"));
    }

    @PostConstruct
    public void startPollingQueryInfo() {
        this.clusterManager.getAllClusters().forEach(uri -> {
            this.remoteClusterInfos.put((URI)uri, this.remoteInfoFactory.createRemoteClusterInfo((URI)uri));
            this.remoteQueryInfos.put((URI)uri, this.remoteInfoFactory.createRemoteQueryInfo((URI)uri));
        });
        this.queryInfoUpdateExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.pollQueryInfos();
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error polling list of queries");
            }
        }, 5L, 5L, TimeUnit.SECONDS);
        this.pollQueryInfos();
    }

    private void pollQueryInfos() {
        ImmutableSet allClusters = ImmutableSet.copyOf(this.clusterManager.getAllClusters());
        ImmutableSet inactiveClusters = Sets.difference((Set)this.remoteQueryInfos.keySet(), (Set)allClusters).immutableCopy();
        ((ConcurrentHashMap.KeySetView)this.remoteQueryInfos.keySet()).removeAll((Collection)inactiveClusters);
        allClusters.forEach(uri -> {
            this.remoteClusterInfos.putIfAbsent((URI)uri, this.remoteInfoFactory.createRemoteClusterInfo((URI)uri));
            this.remoteQueryInfos.putIfAbsent((URI)uri, this.remoteInfoFactory.createRemoteQueryInfo((URI)uri));
        });
        this.remoteClusterInfos.values().forEach(RemoteState::asyncRefresh);
        this.remoteQueryInfos.values().forEach(RemoteState::asyncRefresh);
    }

    public long getRunningQueries() {
        return this.remoteClusterInfos.values().stream().mapToLong(RemoteClusterInfo::getRunningQueries).sum();
    }

    public long getBlockedQueries() {
        return this.remoteClusterInfos.values().stream().mapToLong(RemoteClusterInfo::getBlockedQueries).sum();
    }

    public long getQueuedQueries() {
        return this.remoteClusterInfos.values().stream().mapToLong(RemoteClusterInfo::getQueuedQueries).sum();
    }

    public long getClusterCount() {
        return this.remoteClusterInfos.entrySet().size();
    }

    public long getActiveWorkers() {
        return this.remoteClusterInfos.values().stream().mapToLong(RemoteClusterInfo::getActiveWorkers).sum();
    }

    public long getRunningDrivers() {
        return this.remoteClusterInfos.values().stream().mapToLong(RemoteClusterInfo::getRunningDrivers).sum();
    }

    public List<JsonNode> getAllQueryInfos() {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.remoteQueryInfos.forEach((coordinator, remoteQueryInfo) -> builder.addAll((Iterable)remoteQueryInfo.getQueryList().orElse((List<JsonNode>)ImmutableList.of()).stream().map(queryInfo -> ((ObjectNode)queryInfo).put("coordinatorUri", coordinator.toASCIIString())).collect(ImmutableList.toImmutableList())));
        return builder.build();
    }
}

