/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.cluster;

import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.client.ServerInfo;
import com.facebook.presto.router.cluster.ClusterManager;
import com.facebook.presto.router.cluster.ClusterStatusTracker;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/")
public class ClusterStatusResource {
    private final String environment;
    private final ClusterStatusTracker clusterStatusTracker;
    private final ClusterManager clusterManager;

    @Inject
    public ClusterStatusResource(NodeInfo nodeInfo, ClusterStatusTracker clusterStatusTracker, ClusterManager clusterManager) {
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.clusterStatusTracker = Objects.requireNonNull(clusterStatusTracker, "clusterStatusTracker is null");
        this.clusterManager = Objects.requireNonNull(clusterManager, "clusterManager is null");
    }

    @GET
    @Path(value="/v1/info")
    @Produces(value={"application/json"})
    public ServerInfo getInfo() {
        return new ServerInfo(NodeVersion.UNKNOWN, this.environment, true, false, Optional.empty());
    }

    @GET
    @Path(value="/v1/cluster")
    @Produces(value={"application/json"})
    public ClusterStats getClusterStats() {
        return new ClusterStats(this.clusterStatusTracker.getRunningQueries(), this.clusterStatusTracker.getBlockedQueries(), this.clusterStatusTracker.getQueuedQueries(), this.clusterStatusTracker.getClusterCount(), this.clusterStatusTracker.getActiveWorkers(), this.clusterStatusTracker.getRunningDrivers());
    }

    @GET
    @Path(value="/v1/query")
    public List<JsonNode> getAllQueryInfo(@QueryParam(value="state") String stateFilter) {
        return this.clusterStatusTracker.getAllQueryInfos();
    }

    @GET
    @Path(value="/v1/all")
    @Produces(value={"application/json"})
    public List<URI> getAllClusters() {
        return this.clusterManager.getAllClusters();
    }

    @Immutable
    public static class ClusterStats {
        private final long runningQueries;
        private final long blockedQueries;
        private final long queuedQueries;
        private final long clusterCount;
        private final long activeWorkers;
        private final long runningDrivers;

        @JsonCreator
        public ClusterStats(@JsonProperty(value="runningQueries") long runningQueries, @JsonProperty(value="blockedQueries") long blockedQueries, @JsonProperty(value="queuedQueries") long queuedQueries, @JsonProperty(value="clusterCount") long clusterCount, @JsonProperty(value="activeWorkers") long activeWorkers, @JsonProperty(value="runningDrivers") long runningDrivers) {
            this.runningQueries = runningQueries;
            this.blockedQueries = blockedQueries;
            this.queuedQueries = queuedQueries;
            this.clusterCount = clusterCount;
            this.activeWorkers = activeWorkers;
            this.runningDrivers = runningDrivers;
        }

        @JsonProperty
        public long getRunningQueries() {
            return this.runningQueries;
        }

        @JsonProperty
        public long getBlockedQueries() {
            return this.blockedQueries;
        }

        @JsonProperty
        public long getQueuedQueries() {
            return this.queuedQueries;
        }

        @JsonProperty
        public long getClusterCount() {
            return this.clusterCount;
        }

        @JsonProperty
        public long getActiveWorkers() {
            return this.activeWorkers;
        }

        @JsonProperty
        public long getRunningDrivers() {
            return this.runningDrivers;
        }
    }
}

