/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router.cluster;

import com.facebook.presto.router.RouterConfig;
import com.facebook.presto.router.RouterUtil;
import com.facebook.presto.router.cluster.RequestInfo;
import com.facebook.presto.router.scheduler.Scheduler;
import com.facebook.presto.router.scheduler.SchedulerFactory;
import com.facebook.presto.router.scheduler.SchedulerType;
import com.facebook.presto.router.spec.GroupSpec;
import com.facebook.presto.router.spec.RouterSpec;
import com.facebook.presto.router.spec.SelectorRuleSpec;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ClusterManager {
    private final Map<String, GroupSpec> groups;
    private final List<SelectorRuleSpec> groupSelectors;
    private final SchedulerType schedulerType;
    private final Scheduler scheduler;
    private final HashMap<String, HashMap<URI, Integer>> serverWeights = new HashMap();

    @Inject
    public ClusterManager(RouterConfig config) {
        RouterSpec routerSpec = RouterUtil.parseRouterConfig(config).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "Failed to load router config"));
        this.groups = ImmutableMap.copyOf(routerSpec.getGroups().stream().collect(Collectors.toMap(GroupSpec::getName, group -> group)));
        this.groupSelectors = ImmutableList.copyOf(routerSpec.getSelectors());
        this.schedulerType = routerSpec.getSchedulerType();
        this.scheduler = new SchedulerFactory(routerSpec.getSchedulerType()).create();
        this.initializeServerWeights();
    }

    public List<URI> getAllClusters() {
        return (List)this.groups.values().stream().flatMap(groupSpec -> groupSpec.getMembers().stream()).collect(ImmutableList.toImmutableList());
    }

    public Optional<URI> getDestination(RequestInfo requestInfo) {
        Optional<String> target = this.matchGroup(requestInfo);
        if (!target.isPresent()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((boolean)this.groups.containsKey(target.get()));
        GroupSpec groupSpec = this.groups.get(target.get());
        this.scheduler.setCandidates(groupSpec.getMembers());
        if (this.schedulerType == SchedulerType.WEIGHTED_RANDOM_CHOICE) {
            this.scheduler.setWeights(this.serverWeights.get(groupSpec.getName()));
        }
        return this.scheduler.getDestination(requestInfo.getUser());
    }

    private Optional<String> matchGroup(RequestInfo requestInfo) {
        return this.groupSelectors.stream().map(s -> s.match(requestInfo)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private void initializeServerWeights() {
        this.groups.forEach((name, groupSpec) -> {
            List<URI> members = groupSpec.getMembers();
            List<Integer> weights = groupSpec.getWeights();
            this.serverWeights.put((String)name, new HashMap());
            for (int i = 0; i < members.size(); ++i) {
                this.serverWeights.get(name).put(members.get(i), weights.get(i));
            }
        });
    }
}

