/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.airlift.json.JsonCodecFactory;
import com.facebook.airlift.json.JsonObjectMapperProvider;
import com.facebook.presto.router.RouterConfig;
import com.facebook.presto.router.spec.RouterSpec;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;

public final class RouterUtil {
    private static final JsonCodec<RouterSpec> CODEC = new JsonCodecFactory(() -> new JsonObjectMapperProvider().get().enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES)).jsonCodec(RouterSpec.class);

    private RouterUtil() {
    }

    public static Optional<RouterSpec> parseRouterConfig(RouterConfig config) {
        Optional<Object> routerSpec;
        try {
            routerSpec = Optional.of(CODEC.fromJson(Files.readAllBytes(Paths.get(config.getConfigFile(), new String[0]))));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (IllegalArgumentException e) {
            RouterUtil.handleConfigIllegalArgumentException(e);
            throw e;
        }
        return routerSpec;
    }

    private static void handleConfigIllegalArgumentException(IllegalArgumentException e) {
        Throwable cause = e.getCause();
        if (cause instanceof UnrecognizedPropertyException) {
            UnrecognizedPropertyException ex = (UnrecognizedPropertyException)cause;
            String message = String.format("Unknown property at line %s:%s: %s", ex.getLocation().getLineNr(), ex.getLocation().getColumnNr(), ex.getPropertyName());
            throw new IllegalArgumentException(message, e);
        }
        if (cause instanceof JsonMappingException) {
            if (cause.getCause() != null) {
                cause = cause.getCause();
            }
            throw new IllegalArgumentException(cause.getMessage(), e);
        }
    }
}

