/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router;

import com.facebook.airlift.http.client.HttpUriBuilder;
import com.facebook.airlift.log.Logger;
import com.facebook.presto.router.cluster.ClusterManager;
import com.facebook.presto.router.cluster.RequestInfo;
import com.google.inject.Inject;
import java.net.URI;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/")
public class RouterResource {
    private static final Logger log = Logger.get(RouterResource.class);
    private final ClusterManager clusterManager;

    @Inject
    public RouterResource(ClusterManager clusterManager) {
        this.clusterManager = Objects.requireNonNull(clusterManager, "clusterManager is null");
    }

    @POST
    @Path(value="/v1/statement")
    @Produces(value={"application/json"})
    public Response routeQuery(String statement, @Context HttpServletRequest servletRequest) {
        RequestInfo requestInfo = new RequestInfo(servletRequest, statement);
        URI coordinatorUri = this.clusterManager.getDestination(requestInfo).orElseThrow(() -> RouterResource.badRequest(Response.Status.BAD_GATEWAY, "No Presto cluster available"));
        URI statementUri = HttpUriBuilder.uriBuilderFrom((URI)coordinatorUri).replacePath("/v1/statement").build();
        log.info("route query to %s", new Object[]{statementUri});
        return Response.temporaryRedirect((URI)statementUri).build();
    }

    private static WebApplicationException badRequest(Response.Status status, String message) {
        throw new WebApplicationException(Response.status((Response.Status)status).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)message).build());
    }
}

