/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.router;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.http.client.HttpClientBinder;
import com.facebook.airlift.http.server.HttpServerBinder;
import com.facebook.airlift.jaxrs.JaxrsBinder;
import com.facebook.presto.router.RouterConfig;
import com.facebook.presto.router.RouterResource;
import com.facebook.presto.router.cluster.ClusterManager;
import com.facebook.presto.router.cluster.ClusterStatusResource;
import com.facebook.presto.router.cluster.ClusterStatusTracker;
import com.facebook.presto.router.cluster.ForClusterInfoTracker;
import com.facebook.presto.router.cluster.ForQueryInfoTracker;
import com.facebook.presto.router.cluster.RemoteInfoFactory;
import com.facebook.presto.router.predictor.ForQueryCpuPredictor;
import com.facebook.presto.router.predictor.ForQueryMemoryPredictor;
import com.facebook.presto.router.predictor.PredictorManager;
import com.facebook.presto.router.predictor.RemoteQueryFactory;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import io.airlift.units.Duration;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;

public class RouterModule
extends AbstractConfigurationAwareModule {
    private static final int IDLE_TIMEOUT_SECOND = 30;
    private static final int REQUEST_TIMEOUT_SECOND = 10;
    private static final int PREDICTOR_REQUEST_TIMEOUT_SECOND = 2;
    private static final String QUERY_TRACKER = "query-tracker";
    private static final String QUERY_PREDICTOR = "query-predictor";
    private static final String UI_PATH = "/ui";
    private static final String ROUTER_UI = "router_ui";
    private static final String INDEX_HTML = "index.html";

    protected void setup(Binder binder) {
        HttpServerBinder.httpServerBinder((Binder)binder).bindResource(UI_PATH, ROUTER_UI).withWelcomeFile(INDEX_HTML);
        ConfigBinder.configBinder((Binder)binder).bindConfig(RouterConfig.class);
        binder.bind(ClusterManager.class).in(Scopes.SINGLETON);
        binder.bind(RemoteInfoFactory.class).in(Scopes.SINGLETON);
        this.bindHttpClient(binder, QUERY_TRACKER, ForQueryInfoTracker.class, 30, 10);
        this.bindHttpClient(binder, QUERY_TRACKER, ForClusterInfoTracker.class, 30, 10);
        binder.bind(ClusterStatusTracker.class).in(Scopes.SINGLETON);
        binder.bind(PredictorManager.class).in(Scopes.SINGLETON);
        binder.bind(RemoteQueryFactory.class).in(Scopes.SINGLETON);
        this.bindHttpClient(binder, QUERY_PREDICTOR, ForQueryCpuPredictor.class, 30, 2);
        this.bindHttpClient(binder, QUERY_PREDICTOR, ForQueryMemoryPredictor.class, 30, 2);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(RouterResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ClusterStatusResource.class);
    }

    private void bindHttpClient(Binder binder, String name, Class<? extends Annotation> annotation, int idleTimeout, int requestTimeout) {
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient(name, annotation).withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration((double)idleTimeout, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration((double)requestTimeout, TimeUnit.SECONDS));
        });
    }
}

