/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.plugin.mysql;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.presto.plugin.jdbc.BaseJdbcConfig;
import com.facebook.presto.plugin.jdbc.JdbcClient;
import com.facebook.presto.plugin.mysql.MySqlClient;
import com.facebook.presto.plugin.mysql.MySqlConfig;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.mysql.jdbc.Driver;
import java.sql.SQLException;
import java.util.Properties;

public class MySqlClientModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(JdbcClient.class).to(MySqlClient.class).in(Scopes.SINGLETON);
        MySqlClientModule.ensureCatalogIsEmpty(((BaseJdbcConfig)this.buildConfigObject(BaseJdbcConfig.class)).getConnectionUrl());
        ConfigBinder.configBinder((Binder)binder).bindConfig(MySqlConfig.class);
    }

    private static void ensureCatalogIsEmpty(String connectionUrl) {
        try {
            Driver driver = new Driver();
            Properties urlProperties = driver.parseURL(connectionUrl, null);
            Preconditions.checkArgument((urlProperties != null ? 1 : 0) != 0, (Object)"Invalid JDBC URL for MySQL connector");
            Preconditions.checkArgument((driver.database(urlProperties) == null ? 1 : 0) != 0, (Object)"Database (catalog) must not be specified in JDBC URL for MySQL connector");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

