/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.mysql;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UserDefinedType;
import com.facebook.presto.functionNamespace.AbstractSqlInvokedFunctionNamespaceManager;
import com.facebook.presto.functionNamespace.InvalidFunctionHandleException;
import com.facebook.presto.functionNamespace.ServingCatalog;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.functionNamespace.mysql.FunctionNamespaceDao;
import com.facebook.presto.functionNamespace.mysql.SqlInvokedFunctionRecord;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.FunctionVersion;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jdbi.v3.core.Jdbi;

public class MySqlFunctionNamespaceManager
extends AbstractSqlInvokedFunctionNamespaceManager {
    private static final int MAX_CATALOG_NAME_LENGTH = 128;
    private static final int MAX_SCHEMA_NAME_LENGTH = 128;
    private static final int MAX_FUNCTION_NAME_LENGTH = 256;
    private static final int MAX_PARAMETER_COUNT = 100;
    private static final int MAX_PARAMETER_NAME_LENGTH = 100;
    private static final int MAX_PARAMETER_TYPES_LENGTH = 30000;
    private static final int MAX_RETURN_TYPE_LENGTH = 30000;
    private final Jdbi jdbi;
    private final FunctionNamespaceDao functionNamespaceDao;
    private final Class<? extends FunctionNamespaceDao> functionNamespaceDaoClass;

    @Inject
    public MySqlFunctionNamespaceManager(Jdbi jdbi, FunctionNamespaceDao functionNamespaceDao, Class<? extends FunctionNamespaceDao> functionNamespaceDaoClass, SqlInvokedFunctionNamespaceManagerConfig managerConfig, SqlFunctionExecutors sqlFunctionExecutors, @ServingCatalog String catalogName) {
        super(catalogName, sqlFunctionExecutors, managerConfig);
        this.jdbi = Objects.requireNonNull(jdbi, "jdbi is null");
        this.functionNamespaceDao = Objects.requireNonNull(functionNamespaceDao, "functionNamespaceDao is null");
        this.functionNamespaceDaoClass = Objects.requireNonNull(functionNamespaceDaoClass, "functionNamespaceDaoClass is null");
    }

    @PostConstruct
    public void initialize() {
        this.functionNamespaceDao.createFunctionNamespacesTableIfNotExists();
        this.functionNamespaceDao.createSqlFunctionsTableIfNotExists();
        this.functionNamespaceDao.createUserDefinedTypesTableIfNotExists();
    }

    public Collection<SqlInvokedFunction> listFunctions(Optional<String> likePattern, Optional<String> escape) {
        return likePattern.map(pattern -> this.functionNamespaceDao.listFunctions(this.getCatalogName(), (String)pattern, escape.orElse("\\"))).orElse(this.functionNamespaceDao.listFunctions(this.getCatalogName()));
    }

    public void addUserDefinedType(UserDefinedType type) {
        this.jdbi.useTransaction(handle -> {
            FunctionNamespaceDao transactionDao = (FunctionNamespaceDao)handle.attach(this.functionNamespaceDaoClass);
            QualifiedObjectName typeName = type.getUserDefinedTypeName();
            if (this.functionNamespaceDao.typeExists(typeName.getCatalogName(), typeName.getSchemaName(), typeName.getObjectName())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Type %s already exists", typeName));
            }
            transactionDao.insertUserDefinedType(typeName.getCatalogName(), typeName.getSchemaName(), typeName.getObjectName(), type.getPhysicalTypeSignature().toString());
        });
    }

    public UserDefinedType fetchUserDefinedTypeDirect(QualifiedObjectName typeName) {
        Optional<UserDefinedType> type = this.functionNamespaceDao.getUserDefinedType(typeName.getCatalogName(), typeName.getSchemaName(), typeName.getObjectName());
        if (!type.isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Type %s not found", typeName));
        }
        return type.get();
    }

    protected Collection<SqlInvokedFunction> fetchFunctionsDirect(QualifiedObjectName functionName) {
        this.checkCatalog(functionName);
        return this.functionNamespaceDao.getFunctions(functionName.getCatalogName(), functionName.getSchemaName(), functionName.getObjectName());
    }

    protected FunctionMetadata fetchFunctionMetadataDirect(SqlFunctionHandle functionHandle) {
        this.checkCatalog((FunctionHandle)functionHandle);
        Optional<SqlInvokedFunction> function = this.functionNamespaceDao.getFunction(MySqlFunctionNamespaceManager.hash(functionHandle.getFunctionId()), functionHandle.getFunctionId(), MySqlFunctionNamespaceManager.getLongVersion(functionHandle));
        if (!function.isPresent()) {
            throw new InvalidFunctionHandleException((FunctionHandle)functionHandle);
        }
        return this.sqlInvokedFunctionToMetadata(function.get());
    }

    protected ScalarFunctionImplementation fetchFunctionImplementationDirect(SqlFunctionHandle functionHandle) {
        this.checkCatalog((FunctionHandle)functionHandle);
        Optional<SqlInvokedFunction> function = this.functionNamespaceDao.getFunction(MySqlFunctionNamespaceManager.hash(functionHandle.getFunctionId()), functionHandle.getFunctionId(), MySqlFunctionNamespaceManager.getLongVersion(functionHandle));
        if (!function.isPresent()) {
            throw new InvalidFunctionHandleException((FunctionHandle)functionHandle);
        }
        return this.sqlInvokedFunctionToImplementation(function.get());
    }

    public void createFunction(SqlInvokedFunction function, boolean replace) {
        this.checkCatalog((SqlFunction)function);
        this.checkFunctionLanguageSupported(function);
        Preconditions.checkArgument((!function.hasVersion() ? 1 : 0) != 0, (String)"function '%s' is already versioned", (Object)function);
        QualifiedObjectName functionName = function.getFunctionId().getFunctionName();
        MySqlFunctionNamespaceManager.checkFieldLength("Catalog name", functionName.getCatalogName(), 128);
        MySqlFunctionNamespaceManager.checkFieldLength("Schema name", functionName.getSchemaName(), 128);
        if (!this.functionNamespaceDao.functionNamespaceExists(functionName.getCatalogName(), functionName.getSchemaName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Function namespace not found: %s", functionName.getCatalogSchemaName()));
        }
        MySqlFunctionNamespaceManager.checkFieldLength("Function name", functionName.getObjectName(), 256);
        if (function.getParameters().size() > 100) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Function has more than %s parameters: %s", 100, function.getParameters().size()));
        }
        for (Parameter parameter : function.getParameters()) {
            MySqlFunctionNamespaceManager.checkFieldLength("Parameter name", parameter.getName(), 100);
        }
        MySqlFunctionNamespaceManager.checkFieldLength("Parameter type list", function.getFunctionId().getArgumentTypes().stream().map(TypeSignature::toString).collect(Collectors.joining(",")), 30000);
        MySqlFunctionNamespaceManager.checkFieldLength("Return type", function.getSignature().getReturnType().toString(), 30000);
        this.jdbi.useTransaction(handle -> {
            FunctionNamespaceDao transactionDao = (FunctionNamespaceDao)handle.attach(this.functionNamespaceDaoClass);
            Optional<SqlInvokedFunctionRecord> latestVersion = transactionDao.getLatestRecordForUpdate(MySqlFunctionNamespaceManager.hash(function.getFunctionId()), function.getFunctionId());
            if (!replace && latestVersion.isPresent() && !latestVersion.get().isDeleted()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Function already exists: " + function.getFunctionId());
            }
            if (!latestVersion.isPresent() || !latestVersion.get().getFunction().hasSameDefinitionAs(function)) {
                long newVersion = latestVersion.map(SqlInvokedFunctionRecord::getFunction).map(MySqlFunctionNamespaceManager::getLongVersion).orElse(0L) + 1L;
                this.insertSqlInvokedFunction(transactionDao, function, newVersion);
            } else if (latestVersion.get().isDeleted()) {
                SqlInvokedFunction latest = latestVersion.get().getFunction();
                Preconditions.checkState((boolean)latest.hasVersion(), (String)"Function version missing: %s", (Object)latest.getFunctionId());
                transactionDao.setDeletionStatus(MySqlFunctionNamespaceManager.hash(latest.getFunctionId()), latest.getFunctionId(), MySqlFunctionNamespaceManager.getLongVersion(latest), false);
            }
        });
        this.refreshFunctionsCache(functionName);
    }

    public void alterFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        this.checkCatalog(functionName);
        this.jdbi.useTransaction(handle -> {
            FunctionNamespaceDao transactionDao = (FunctionNamespaceDao)handle.attach(this.functionNamespaceDaoClass);
            List<SqlInvokedFunction> functions = this.getSqlFunctions(transactionDao, functionName, parameterTypes);
            MySqlFunctionNamespaceManager.checkUnique(functions, functionName);
            MySqlFunctionNamespaceManager.checkExists(functions, functionName, parameterTypes);
            SqlInvokedFunction latest = functions.get(0);
            RoutineCharacteristics.Builder routineCharacteristics = RoutineCharacteristics.builder((RoutineCharacteristics)latest.getRoutineCharacteristics());
            alterRoutineCharacteristics.getNullCallClause().ifPresent(arg_0 -> ((RoutineCharacteristics.Builder)routineCharacteristics).setNullCallClause(arg_0));
            SqlInvokedFunction altered = new SqlInvokedFunction(latest.getFunctionId().getFunctionName(), latest.getParameters(), latest.getSignature().getReturnType(), latest.getDescription(), routineCharacteristics.build(), latest.getBody(), FunctionVersion.notVersioned());
            if (!altered.hasSameDefinitionAs(latest)) {
                Preconditions.checkState((boolean)latest.hasVersion(), (String)"Function version missing: %s", (Object)latest.getFunctionId());
                this.insertSqlInvokedFunction(transactionDao, altered, MySqlFunctionNamespaceManager.getLongVersion(latest) + 1L);
            }
        });
        this.refreshFunctionsCache(functionName);
    }

    public void dropFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        this.checkCatalog(functionName);
        this.jdbi.useTransaction(handle -> {
            FunctionNamespaceDao transactionDao = (FunctionNamespaceDao)handle.attach(this.functionNamespaceDaoClass);
            List<SqlInvokedFunction> functions = this.getSqlFunctions(transactionDao, functionName, parameterTypes);
            MySqlFunctionNamespaceManager.checkExists(functions, functionName, parameterTypes);
            if (!parameterTypes.isPresent()) {
                transactionDao.setDeleted(functionName.getCatalogName(), functionName.getSchemaName(), functionName.getObjectName());
            } else {
                SqlInvokedFunction latest = (SqlInvokedFunction)Iterables.getOnlyElement(functions);
                Preconditions.checkState((boolean)latest.hasVersion(), (String)"Function version missing: %s", (Object)latest.getFunctionId());
                transactionDao.setDeletionStatus(MySqlFunctionNamespaceManager.hash(latest.getFunctionId()), latest.getFunctionId(), MySqlFunctionNamespaceManager.getLongVersion(latest), true);
            }
        });
        this.refreshFunctionsCache(functionName);
    }

    private List<SqlInvokedFunction> getSqlFunctions(FunctionNamespaceDao functionNamespaceDao, QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes) {
        List<Object> records = new ArrayList();
        if (parameterTypes.isPresent()) {
            SqlFunctionId functionId = new SqlFunctionId(functionName, parameterTypes.get());
            functionNamespaceDao.getLatestRecordForUpdate(MySqlFunctionNamespaceManager.hash(functionId), functionId).ifPresent(records::add);
        } else {
            records = functionNamespaceDao.getLatestRecordsForUpdate(functionName.getCatalogName(), functionName.getSchemaName(), functionName.getObjectName());
        }
        return (List)records.stream().filter(record -> !record.isDeleted()).map(SqlInvokedFunctionRecord::getFunction).collect(ImmutableList.toImmutableList());
    }

    private void insertSqlInvokedFunction(FunctionNamespaceDao functionNamespaceDao, SqlInvokedFunction function, long version) {
        QualifiedObjectName functionName = function.getFunctionId().getFunctionName();
        functionNamespaceDao.insertFunction(MySqlFunctionNamespaceManager.hash(function.getFunctionId()), function.getFunctionId(), version, functionName.getCatalogName(), functionName.getSchemaName(), functionName.getObjectName(), function.getParameters(), function.getSignature().getReturnType(), function.getDescription(), function.getRoutineCharacteristics(), function.getBody());
    }

    private static long getLongVersion(SqlFunctionHandle functionHandle) {
        return Long.parseLong(functionHandle.getVersion());
    }

    private static long getLongVersion(SqlInvokedFunction function) {
        return Long.parseLong(function.getRequiredVersion());
    }

    private static void checkFieldLength(String fieldName, String field, int maxLength) {
        if (field.length() > maxLength) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("%s exceeds max length of %s: %s", fieldName, maxLength, field));
        }
    }

    private static void checkUnique(List<SqlInvokedFunction> functions, QualifiedObjectName functionName) {
        if (functions.size() > 1) {
            String signatures = functions.stream().map(SqlFunction::getSignature).map(Signature::toString).collect(Collectors.joining("; "));
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_CALL, String.format("Function '%s' has multiple signatures: %s. Please specify parameter types.", functionName, signatures));
        }
    }

    private static void checkExists(List<SqlInvokedFunction> functions, QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes) {
        if (functions.isEmpty()) {
            String formattedParameterTypes = parameterTypes.map(types -> types.stream().map(TypeSignature::toString).collect(Collectors.joining(",", "(", ")"))).orElse("");
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Function not found: %s%s", functionName, formattedParameterTypes));
        }
    }

    private static String hash(SqlFunctionId functionId) {
        return Hashing.sha256().hashString((CharSequence)functionId.toString(), StandardCharsets.UTF_8).toString();
    }
}

