/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.json;

import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.function.AggregationFunctionMetadata;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

public class JsonBasedUdfFunctionMetadata {
    private final String docString;
    private final FunctionKind functionKind;
    private final TypeSignature outputType;
    private final List<TypeSignature> paramTypes;
    private final String schema;
    private final RoutineCharacteristics routineCharacteristics;
    private final Optional<AggregationFunctionMetadata> aggregateMetadata;

    @JsonCreator
    public JsonBasedUdfFunctionMetadata(@JsonProperty(value="docString") String docString, @JsonProperty(value="functionKind") FunctionKind functionKind, @JsonProperty(value="outputType") TypeSignature outputType, @JsonProperty(value="paramTypes") List<TypeSignature> paramTypes, @JsonProperty(value="schema") String schema, @JsonProperty(value="routineCharacteristics") RoutineCharacteristics routineCharacteristics, @JsonProperty(value="aggregateMetadata") Optional<AggregationFunctionMetadata> aggregateMetadata) {
        this.docString = Objects.requireNonNull(docString, "docString is null");
        this.functionKind = Objects.requireNonNull(functionKind, "functionKind is null");
        this.outputType = Objects.requireNonNull(outputType, "outputType is null");
        this.paramTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(paramTypes, "paramTypes is null"));
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.routineCharacteristics = Objects.requireNonNull(routineCharacteristics, "routineCharacteristics is null");
        this.aggregateMetadata = Objects.requireNonNull(aggregateMetadata, "aggregateMetadata is null");
        Preconditions.checkArgument((functionKind == FunctionKind.AGGREGATE && aggregateMetadata.isPresent() || functionKind != FunctionKind.AGGREGATE && !aggregateMetadata.isPresent() ? 1 : 0) != 0, (Object)"aggregateMetadata must be present for aggregation functions and absent otherwise");
    }

    public String getDocString() {
        return this.docString;
    }

    public FunctionKind getFunctionKind() {
        return this.functionKind;
    }

    public TypeSignature getOutputType() {
        return this.outputType;
    }

    public List<String> getParamNames() {
        return (List)IntStream.range(0, this.paramTypes.size()).boxed().map(idx -> "input" + idx).collect(ImmutableList.toImmutableList());
    }

    public List<TypeSignature> getParamTypes() {
        return this.paramTypes;
    }

    public String getSchema() {
        return this.schema;
    }

    public RoutineCharacteristics getRoutineCharacteristics() {
        return this.routineCharacteristics;
    }

    public Optional<AggregationFunctionMetadata> getAggregateMetadata() {
        return this.aggregateMetadata;
    }
}

