/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.mysql;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UserDefinedType;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class EnumTypeRowMapper
implements RowMapper<UserDefinedType> {
    public UserDefinedType map(ResultSet rs, StatementContext ctx) throws SQLException {
        QualifiedObjectName typeName = QualifiedObjectName.valueOf((String)rs.getString("catalog_name"), (String)rs.getString("schema_name"), (String)rs.getString("type_name"));
        String physicalType = rs.getString("physical_type");
        TypeSignature typeSignature = TypeSignature.parseTypeSignature((String)physicalType);
        Preconditions.checkArgument((boolean)typeSignature.isEnum(), (Object)"Expect enum type");
        return new UserDefinedType(typeName, typeSignature);
    }
}

