/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.mysql;

import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UserDefinedType;
import com.facebook.presto.functionNamespace.mysql.DefineEnumTypesTable;
import com.facebook.presto.functionNamespace.mysql.DefineFunctionNamespacesTable;
import com.facebook.presto.functionNamespace.mysql.DefineSqlFunctionsTable;
import com.facebook.presto.functionNamespace.mysql.EnumTypeRowMapper;
import com.facebook.presto.functionNamespace.mysql.RoutineCharacteristicsArgumentFactory;
import com.facebook.presto.functionNamespace.mysql.SqlFunctionIdArgumentFactory;
import com.facebook.presto.functionNamespace.mysql.SqlInvokedFunctionRecord;
import com.facebook.presto.functionNamespace.mysql.SqlInvokedFunctionRecordRowMapper;
import com.facebook.presto.functionNamespace.mysql.SqlInvokedFunctionRowMapper;
import com.facebook.presto.functionNamespace.mysql.SqlParametersArgumentFactory;
import com.facebook.presto.functionNamespace.mysql.TypeSignatureArgumentFactory;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactories;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.config.RegisterRowMappers;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

@RegisterRowMappers(value={@RegisterRowMapper(value=SqlInvokedFunctionRowMapper.class), @RegisterRowMapper(value=SqlInvokedFunctionRecordRowMapper.class), @RegisterRowMapper(value=EnumTypeRowMapper.class)})
@RegisterArgumentFactories(value={@RegisterArgumentFactory(value=SqlFunctionIdArgumentFactory.class), @RegisterArgumentFactory(value=SqlParametersArgumentFactory.class), @RegisterArgumentFactory(value=TypeSignatureArgumentFactory.class), @RegisterArgumentFactory(value=RoutineCharacteristicsArgumentFactory.class)})
@DefineFunctionNamespacesTable
@DefineSqlFunctionsTable
@DefineEnumTypesTable
public interface FunctionNamespaceDao {
    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS <function_namespaces_table> (\n   catalog_name varchar(128) NOT NULL,\n   schema_name varchar(128) NOT NULL,\n   PRIMARY KEY (catalog_name, schema_name))")
    public void createFunctionNamespacesTableIfNotExists();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS <sql_functions_table> (\n  id bigint(20) NOT NULL AUTO_INCREMENT,\n  function_id_hash varchar(128) NOT NULL,\n  function_id text NOT NULL,\n  version bigint(20) unsigned NOT NULL,\n  catalog_name varchar(128) NOT NULL,\n  schema_name varchar(128) NOT NULL,\n  function_name varchar(256) NOT NULL,\n  parameters text NOT NULL,\n  return_type text NOT NULL,\n  routine_characteristics text NOT NULL,\n  body mediumtext,\n  description text,\n  deleted boolean NOT NULL DEFAULT false,\n  delete_time TIMESTAMP NULL DEFAULT NULL,\n  create_time TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,\n  update_time TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n  PRIMARY KEY (id),\n  KEY function_id_hash_version (function_id_hash, version),\n  KEY qualified_function_name (catalog_name, schema_name, function_name))")
    public void createSqlFunctionsTableIfNotExists();

    @SqlUpdate(value="CREATE TABLE IF NOT EXISTS <enum_types_table> (\n   id bigint(20) NOT NULL AUTO_INCREMENT,\n  catalog_name varchar(128) NOT NULL,\n  schema_name varchar(128) NOT NULL,\n  type_name varchar(256) NOT NULL,\n  physical_type text NOT NULL,\n  PRIMARY KEY (id), \n  UNIQUE KEY type_name (catalog_name, schema_name, type_name))")
    public void createEnumTypesTableIfNotExists();

    @SqlQuery(value="SELECT\n   count(1) > 0\nFROM <function_namespaces_table>\nWHERE catalog_name = :catalog_name\n  AND schema_name = :schema_name")
    public boolean functionNamespaceExists(@Bind(value="catalog_name") String var1, @Bind(value="schema_name") String var2);

    @SqlQuery(value="SELECT\n    t.catalog_name,\n    t.schema_name,\n    t.function_name,\n    t.parameters,\n    t.return_type,\n    t.description,\n    t.routine_characteristics,\n    t.body,\n    t.version\nFROM <sql_functions_table> t\nJOIN (\n    SELECT\n        function_id_hash,\n        function_id,\n        MAX(version) version\n    FROM <sql_functions_table>\n    WHERE catalog_name = :catalog_name\n    GROUP BY\n        function_id_hash,\n        function_id\n) v\n    ON t.function_id_hash = v.function_id_hash\n    AND t.function_id = v.function_id\n     AND t.version = v.version\nWHERE\n    NOT t.deleted")
    public List<SqlInvokedFunction> listFunctions(@Bind(value="catalog_name") String var1);

    @SqlQuery(value="SELECT\n    t.catalog_name,\n    t.schema_name,\n    t.function_name,\n    t.parameters,\n    t.return_type,\n    t.description,\n    t.routine_characteristics,\n    t.body,\n    t.version\nFROM <sql_functions_table> t\nJOIN (\n    SELECT\n        function_id_hash,\n        function_id,\n        MAX(version) version\n    FROM <sql_functions_table>\n    WHERE catalog_name = :catalog_name\n      AND schema_name = :schema_name\n      AND function_name = :function_name\n    GROUP BY\n        function_id_hash,\n        function_id\n) v\n    ON t.function_id_hash = v.function_id_hash\n     AND t.function_id = v.function_id\n     AND t.version = v.version\nWHERE\n    NOT t.deleted")
    public List<SqlInvokedFunction> getFunctions(@Bind(value="catalog_name") String var1, @Bind(value="schema_name") String var2, @Bind(value="function_name") String var3);

    @SqlQuery(value="SELECT\n    catalog_name,\n    schema_name,\n    function_name,\n    parameters,\n    return_type,\n    description,\n    routine_characteristics,\n    body,\n    version\nFROM <sql_functions_table>\nWHERE\n    function_id_hash = :function_id_hash\n    AND function_id = :function_id\n    AND version = :version")
    public Optional<SqlInvokedFunction> getFunction(@Bind(value="function_id_hash") String var1, @Bind(value="function_id") SqlFunctionId var2, @Bind(value="version") long var3);

    @SqlQuery(value="SELECT\n    t.catalog_name,\n    t.schema_name,\n    t.function_name,\n    t.parameters,\n    t.return_type,\n    t.description,\n    t.routine_characteristics,\n    t.body,\n    t.version,\n    t.deleted\nFROM <sql_functions_table> t\nJOIN (\n    SELECT\n        MAX(version) version\n    FROM <sql_functions_table>\n    WHERE\n        function_id_hash = :function_id_hash\n        AND function_id = :function_id\n) v\nON\n    t.version = v.version\nWHERE\n    t.function_id_hash = :function_id_hash\n    AND t.function_id = :function_id\nFOR UPDATE")
    public Optional<SqlInvokedFunctionRecord> getLatestRecordForUpdate(@Bind(value="function_id_hash") String var1, @Bind(value="function_id") SqlFunctionId var2);

    @SqlQuery(value="SELECT\n    t.catalog_name,\n    t.schema_name,\n    t.function_name,\n    t.parameters,\n    t.return_type,\n    t.description,\n    t.routine_characteristics,\n    t.body,\n    t.version,\n    t.deleted\nFROM <sql_functions_table> t\nJOIN (\n    SELECT\n        function_id_hash,\n        function_id,\n        MAX(version) version\n    FROM <sql_functions_table>\n    WHERE\n        catalog_name = :catalog_name\n        AND schema_name = :schema_name\n        AND function_name = :function_name\n    GROUP BY\n        function_id_hash,\n        function_id\n) v\nON\n    t.function_id_hash = v.function_id_hash\n    AND t.function_id = v.function_id\n    AND t.version = v.version\nFOR UPDATE")
    public List<SqlInvokedFunctionRecord> getLatestRecordsForUpdate(@Bind(value="catalog_name") String var1, @Bind(value="schema_name") String var2, @Bind(value="function_name") String var3);

    @SqlUpdate(value="INSERT INTO <sql_functions_table> (\n        function_id_hash,\n        function_id,\n        version,\n        catalog_name,\n        schema_name,\n        function_name,\n        parameters,\n        return_type,\n        description,\n        routine_characteristics,\n        body\n    )\nVALUES\n    (\n        :function_id_hash,\n        :function_id,\n        :version,\n        :catalog_name,\n        :schema_name,\n        :function_name,\n        :parameters,\n        :return_type,\n        :description,\n        :routine_characteristics,\n        :body\n    )")
    public void insertFunction(@Bind(value="function_id_hash") String var1, @Bind(value="function_id") SqlFunctionId var2, @Bind(value="version") long var3, @Bind(value="catalog_name") String var5, @Bind(value="schema_name") String var6, @Bind(value="function_name") String var7, @Bind(value="parameters") List<Parameter> var8, @Bind(value="return_type") TypeSignature var9, @Bind(value="description") String var10, @Bind(value="routine_characteristics") RoutineCharacteristics var11, @Bind(value="body") String var12);

    @SqlUpdate(value="UPDATE\n    <sql_functions_table>\nSET\n    deleted = :deleted\n,    delete_time = IF(:deleted, NOW(), null)\nWHERE\n    function_id_hash = :function_id_hash\n    AND function_id = :function_id\n    AND version = :version")
    public int setDeletionStatus(@Bind(value="function_id_hash") String var1, @Bind(value="function_id") SqlFunctionId var2, @Bind(value="version") long var3, @Bind(value="deleted") boolean var5);

    @SqlQuery(value="SELECT\n   count(1) > 0\nFROM <enum_types_table>\nWHERE catalog_name = :catalog_name\n  AND schema_name = :schema_name\n  AND type_name = :type_name")
    public boolean enumTypeExists(@Bind(value="catalog_name") String var1, @Bind(value="schema_name") String var2, @Bind(value="type_name") String var3);

    @SqlQuery(value="SELECT\n    catalog_name,\n    schema_name,\n    type_name,\n    physical_type\n  FROM <enum_types_table>\nWHERE\n    catalog_name = :catalog_name\n    AND schema_name = :schema_name\n    AND type_name = :type_name")
    public Optional<UserDefinedType> getEnumType(@Bind(value="catalog_name") String var1, @Bind(value="schema_name") String var2, @Bind(value="type_name") String var3);

    @SqlUpdate(value="INSERT INTO <enum_types_table> (\n        catalog_name,\n        schema_name,\n        type_name,\n        physical_type\n    )\nVALUES\n    (\n        :catalog_name,\n        :schema_name,\n        :type_name,\n        :physical_type\n    )")
    public void insertEnumType(@Bind(value="catalog_name") String var1, @Bind(value="schema_name") String var2, @Bind(value="type_name") String var3, @Bind(value="physical_type") String var4);
}

