/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.mysql;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.type.LongEnumParametricType;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.common.type.VarcharEnumParametricType;
import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class EnumParametricTypeRowMapper
implements RowMapper<ParametricType> {
    private static final JsonCodec<List<String>> PARAMETERS_CODEC = JsonCodec.listJsonCodec(String.class);

    public ParametricType map(ResultSet rs, StatementContext ctx) throws SQLException {
        QualifiedObjectName typeName = QualifiedObjectName.valueOf((String)rs.getString("catalog_name"), (String)rs.getString("schema_name"), (String)rs.getString("type_name"));
        List typeParameters = (List)PARAMETERS_CODEC.fromJson(rs.getString("type_parameters"));
        Preconditions.checkArgument((typeParameters.size() == 1 ? 1 : 0) != 0, (Object)"Expect enum type to have 1 parameter");
        TypeSignature typeSignature = TypeSignature.parseTypeSignature((String)String.format("%s(%s)", typeName, typeParameters.get(0)));
        Preconditions.checkArgument((boolean)typeSignature.isEnum(), (Object)"Expect enum type");
        if (typeSignature.isLongEnum()) {
            return new LongEnumParametricType(typeName, ((TypeSignatureParameter)typeSignature.getParameters().get(0)).getLongEnumMap());
        }
        return new VarcharEnumParametricType(typeName, ((TypeSignatureParameter)typeSignature.getParameters().get(0)).getVarcharEnumMap());
    }
}

