/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.execution.thrift;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.drift.TException;
import com.facebook.drift.client.DriftClient;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.ThriftScalarFunctionImplementation;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBlock;
import com.facebook.presto.thrift.api.udf.ThriftFunctionHandle;
import com.facebook.presto.thrift.api.udf.ThriftUdfPage;
import com.facebook.presto.thrift.api.udf.ThriftUdfService;
import com.facebook.presto.thrift.api.udf.ThriftUdfServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class ThriftSqlFunctionExecutor {
    private final DriftClient<ThriftUdfService> thriftUdfClient;

    @Inject
    public ThriftSqlFunctionExecutor(DriftClient<ThriftUdfService> thriftUdfClient) {
        this.thriftUdfClient = thriftUdfClient;
    }

    public CompletableFuture<Block> executeFunction(ThriftScalarFunctionImplementation functionImplementation, Page input, List<Integer> channels, List<Type> argumentTypes, Type returnType) {
        if (this.thriftUdfClient == null) {
            throw new UnsupportedOperationException("Thrift function execution is not supported");
        }
        ImmutableList.Builder blocks = ImmutableList.builder();
        for (int i = 0; i < channels.size(); ++i) {
            Block block = input.getBlock(channels.get(i).intValue());
            blocks.add((Object)PrestoThriftBlock.fromBlock((Block)block, (Type)argumentTypes.get(i)));
        }
        SqlFunctionHandle functionHandle = functionImplementation.getFunctionHandle();
        SqlFunctionId functionId = functionHandle.getFunctionId();
        try {
            return MoreFutures.toCompletableFuture((ListenableFuture)((ThriftUdfService)this.thriftUdfClient.get(Optional.of(functionImplementation.getLanguage().getLanguage()))).invokeUdf(new ThriftFunctionHandle(functionId.getFunctionName().toString(), (List)functionId.getArgumentTypes().stream().map(TypeSignature::toString).collect(ImmutableList.toImmutableList()), returnType.toString(), functionHandle.getVersion()), ThriftUdfPage.thriftPage((List)blocks.build()))).thenApply(result -> ((PrestoThriftBlock)Iterables.getOnlyElement((Iterable)result.getResult().getThriftBlocks())).toBlock(returnType));
        }
        catch (TException | ThriftUdfServiceException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, e);
        }
    }
}

