/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.testing;

import com.facebook.presto.common.function.QualifiedFunctionName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.functionNamespace.AbstractSqlInvokedFunctionNamespaceManager;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class InMemoryFunctionNamespaceManager
extends AbstractSqlInvokedFunctionNamespaceManager {
    private final Map<SqlFunctionId, SqlInvokedFunction> latestFunctions = new ConcurrentHashMap<SqlFunctionId, SqlInvokedFunction>();

    public InMemoryFunctionNamespaceManager(String catalogName, SqlInvokedFunctionNamespaceManagerConfig config) {
        super(catalogName, config);
    }

    public synchronized void createFunction(SqlInvokedFunction function, boolean replace) {
        this.checkFunctionLanguageSupported(function);
        SqlFunctionId functionId = function.getFunctionId();
        if (!replace && this.latestFunctions.containsKey(function.getFunctionId())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Function '%s' already exists", functionId.getId()));
        }
        SqlInvokedFunction replacedFunction = this.latestFunctions.get(functionId);
        long version = 1L;
        if (replacedFunction != null) {
            version = Long.parseLong(replacedFunction.getRequiredVersion()) + 1L;
        }
        this.latestFunctions.put(functionId, function.withVersion(String.valueOf(version)));
    }

    public void alterFunction(QualifiedFunctionName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Alter Function is not supported in InMemoryFunctionNamespaceManager");
    }

    public synchronized void dropFunction(QualifiedFunctionName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Drop Function is not supported in InMemoryFunctionNamespaceManager");
    }

    public Collection<SqlInvokedFunction> listFunctions() {
        return this.latestFunctions.values();
    }

    @Override
    public Collection<SqlInvokedFunction> fetchFunctionsDirect(QualifiedFunctionName name) {
        return (Collection)this.latestFunctions.values().stream().filter(function -> function.getSignature().getName().equals((Object)name)).map(InMemoryFunctionNamespaceManager::copyFunction).collect(ImmutableList.toImmutableList());
    }

    @Override
    public FunctionMetadata fetchFunctionMetadataDirect(SqlFunctionHandle functionHandle) {
        return (FunctionMetadata)this.fetchFunctionsDirect(functionHandle.getFunctionId().getFunctionName()).stream().filter(function -> function.getRequiredFunctionHandle().equals((Object)functionHandle)).map(this::sqlInvokedFunctionToMetadata).collect(MoreCollectors.onlyElement());
    }

    @Override
    protected ScalarFunctionImplementation fetchFunctionImplementationDirect(SqlFunctionHandle functionHandle) {
        return (ScalarFunctionImplementation)this.fetchFunctionsDirect(functionHandle.getFunctionId().getFunctionName()).stream().filter(function -> function.getRequiredFunctionHandle().equals((Object)functionHandle)).map(this::sqlInvokedFunctionToImplementation).collect(MoreCollectors.onlyElement());
    }

    private static SqlInvokedFunction copyFunction(SqlInvokedFunction function) {
        return new SqlInvokedFunction(function.getSignature().getName(), function.getParameters(), function.getSignature().getReturnType(), function.getDescription(), function.getRoutineCharacteristics(), function.getBody(), function.getVersion());
    }
}

