/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class SqlInvokedFunctionNamespaceManagerConfig {
    private static final JsonCodec<Map<RoutineCharacteristics.Language, FunctionImplementationType>> FUNCTION_LANGUAGES_CODEC = JsonCodec.mapJsonCodec(RoutineCharacteristics.Language.class, FunctionImplementationType.class);
    private Duration functionCacheExpiration = new Duration(5.0, TimeUnit.MINUTES);
    private Duration functionInstanceCacheExpiration = new Duration(8.0, TimeUnit.HOURS);
    private Map<RoutineCharacteristics.Language, FunctionImplementationType> supportedFunctionLanguages = ImmutableMap.of((Object)RoutineCharacteristics.Language.SQL, (Object)FunctionImplementationType.SQL);

    @MinDuration(value="0ns")
    public Duration getFunctionCacheExpiration() {
        return this.functionCacheExpiration;
    }

    @Config(value="function-cache-expiration")
    public SqlInvokedFunctionNamespaceManagerConfig setFunctionCacheExpiration(Duration functionCacheExpiration) {
        this.functionCacheExpiration = functionCacheExpiration;
        return this;
    }

    @MinDuration(value="0ns")
    public Duration getFunctionInstanceCacheExpiration() {
        return this.functionInstanceCacheExpiration;
    }

    @Config(value="function-instance-cache-expiration")
    public SqlInvokedFunctionNamespaceManagerConfig setFunctionInstanceCacheExpiration(Duration functionInstanceCacheExpiration) {
        this.functionInstanceCacheExpiration = functionInstanceCacheExpiration;
        return this;
    }

    public Map<RoutineCharacteristics.Language, FunctionImplementationType> getSupportedFunctionLanguages() {
        return this.supportedFunctionLanguages;
    }

    @Config(value="supported-function-languages")
    public SqlInvokedFunctionNamespaceManagerConfig setSupportedFunctionLanguages(String languages) {
        this.supportedFunctionLanguages = (Map)FUNCTION_LANGUAGES_CODEC.fromJson(languages);
        return this;
    }
}

