/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.mysql;

import com.facebook.airlift.json.JsonCodec;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.function.QualifiedFunctionName;
import com.facebook.presto.spi.function.RoutineCharacteristics;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlParameter;
import com.facebook.presto.spi.type.TypeSignature;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class SqlInvokedFunctionRowMapper
implements RowMapper<SqlInvokedFunction> {
    private static final JsonCodec<List<SqlParameter>> SQL_PARAMETERS_CODEC = JsonCodec.listJsonCodec(SqlParameter.class);
    private static final JsonCodec<RoutineCharacteristics> ROUTINE_CHARACTERISTICS_CODEC = JsonCodec.jsonCodec(RoutineCharacteristics.class);

    public SqlInvokedFunction map(ResultSet rs, StatementContext ctx) throws SQLException {
        String catalog = rs.getString("catalog_name");
        String schema = rs.getString("schema_name");
        String functionName = rs.getString("function_name");
        List parameters = (List)SQL_PARAMETERS_CODEC.fromJson(rs.getString("parameters"));
        String returnType = rs.getString("return_type");
        String description = rs.getString("description");
        RoutineCharacteristics routineCharacteristics = (RoutineCharacteristics)ROUTINE_CHARACTERISTICS_CODEC.fromJson(rs.getString("routine_characteristics"));
        String body = rs.getString("body");
        long version = rs.getLong("version");
        return new SqlInvokedFunction(QualifiedFunctionName.of((CatalogSchemaName)new CatalogSchemaName(catalog, schema), (String)functionName), parameters, TypeSignature.parseTypeSignature((String)returnType), description, routineCharacteristics, body, Optional.of(version));
    }
}

