/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.units.Duration;
import com.facebook.airlift.units.MinDuration;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class SqlInvokedFunctionNamespaceManagerConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private Duration functionCacheExpiration = new Duration(5.0, TimeUnit.MINUTES);
    private Duration functionInstanceCacheExpiration = new Duration(8.0, TimeUnit.HOURS);
    private Duration typeCacheExpiration = new Duration(1.0, TimeUnit.HOURS);
    private Set<String> supportedFunctionLanguages = ImmutableSet.of((Object)"sql");

    @MinDuration(value="0ns")
    public @MinDuration(value="0ns") Duration getFunctionCacheExpiration() {
        return this.functionCacheExpiration;
    }

    @Config(value="function-cache-expiration")
    public SqlInvokedFunctionNamespaceManagerConfig setFunctionCacheExpiration(Duration functionCacheExpiration) {
        this.functionCacheExpiration = functionCacheExpiration;
        return this;
    }

    @MinDuration(value="0ns")
    public @MinDuration(value="0ns") Duration getFunctionInstanceCacheExpiration() {
        return this.functionInstanceCacheExpiration;
    }

    @Config(value="function-instance-cache-expiration")
    public SqlInvokedFunctionNamespaceManagerConfig setFunctionInstanceCacheExpiration(Duration functionInstanceCacheExpiration) {
        this.functionInstanceCacheExpiration = functionInstanceCacheExpiration;
        return this;
    }

    @MinDuration(value="0ns")
    public @MinDuration(value="0ns") Duration getTypeCacheExpiration() {
        return this.typeCacheExpiration;
    }

    @Config(value="type-cache-expiration")
    public SqlInvokedFunctionNamespaceManagerConfig setTypeCacheExpiration(Duration typeCacheExpiration) {
        this.typeCacheExpiration = typeCacheExpiration;
        return this;
    }

    @Config(value="supported-function-languages")
    public SqlInvokedFunctionNamespaceManagerConfig setSupportedFunctionLanguages(String languages) {
        this.supportedFunctionLanguages = ImmutableSet.copyOf((Iterable)SPLITTER.split((CharSequence)languages));
        return this;
    }

    public Set<String> getSupportedFunctionLanguages() {
        return this.supportedFunctionLanguages;
    }
}

