/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.functionNamespace.testing;

import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UserDefinedType;
import com.facebook.presto.functionNamespace.AbstractSqlInvokedFunctionNamespaceManager;
import com.facebook.presto.functionNamespace.SqlInvokedFunctionNamespaceManagerConfig;
import com.facebook.presto.functionNamespace.execution.SqlFunctionExecutors;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AlterRoutineCharacteristics;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.SqlFunctionHandle;
import com.facebook.presto.spi.function.SqlFunctionId;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import com.google.errorprone.annotations.ThreadSafe;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@ThreadSafe
public class InMemoryFunctionNamespaceManager
extends AbstractSqlInvokedFunctionNamespaceManager {
    private final Map<SqlFunctionId, SqlInvokedFunction> latestFunctions = new ConcurrentHashMap<SqlFunctionId, SqlInvokedFunction>();
    private final Map<TypeSignature, Type> types = new ConcurrentHashMap<TypeSignature, Type>();
    private final Map<QualifiedObjectName, UserDefinedType> userDefinedTypes = new ConcurrentHashMap<QualifiedObjectName, UserDefinedType>();

    public InMemoryFunctionNamespaceManager(String catalogName, SqlFunctionExecutors sqlFunctionExecutors, SqlInvokedFunctionNamespaceManagerConfig config) {
        super(catalogName, sqlFunctionExecutors, config);
    }

    @Override
    public void setBlockEncodingSerde(BlockEncodingSerde blockEncodingSerde) {
    }

    public synchronized void createFunction(SqlInvokedFunction function, boolean replace) {
        this.checkFunctionLanguageSupported(function);
        SqlFunctionId functionId = function.getFunctionId();
        if (!replace && this.latestFunctions.containsKey(function.getFunctionId())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("Function '%s' already exists", functionId.getId()));
        }
        SqlInvokedFunction replacedFunction = this.latestFunctions.get(functionId);
        long version = 1L;
        if (replacedFunction != null) {
            version = Long.parseLong(replacedFunction.getRequiredVersion()) + 1L;
        }
        this.latestFunctions.put(functionId, function.withVersion(String.valueOf(version)));
    }

    public void alterFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, AlterRoutineCharacteristics alterRoutineCharacteristics) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Alter Function is not supported in InMemoryFunctionNamespaceManager");
    }

    public synchronized void dropFunction(QualifiedObjectName functionName, Optional<List<TypeSignature>> parameterTypes, boolean exists) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Drop Function is not supported in InMemoryFunctionNamespaceManager");
    }

    public Collection<SqlInvokedFunction> listFunctions(Optional<String> likePattern, Optional<String> escape) {
        return this.latestFunctions.values();
    }

    public void addUserDefinedType(UserDefinedType type) {
        QualifiedObjectName name = type.getUserDefinedTypeName();
        Preconditions.checkArgument((!this.userDefinedTypes.containsKey(name) ? 1 : 0) != 0, (String)"Parametric type %s already registered", (Object)name);
        this.userDefinedTypes.put(name, type);
    }

    @Override
    public Collection<SqlInvokedFunction> fetchFunctionsDirect(QualifiedObjectName name) {
        return (Collection)this.latestFunctions.values().stream().filter(function -> function.getSignature().getName().equals((Object)name)).map(InMemoryFunctionNamespaceManager::copyFunction).collect(ImmutableList.toImmutableList());
    }

    @Override
    protected UserDefinedType fetchUserDefinedTypeDirect(QualifiedObjectName typeName) {
        return this.userDefinedTypes.get(typeName);
    }

    @Override
    public FunctionMetadata fetchFunctionMetadataDirect(SqlFunctionHandle functionHandle) {
        return (FunctionMetadata)this.fetchFunctionsDirect(functionHandle.getFunctionId().getFunctionName()).stream().filter(function -> function.getRequiredFunctionHandle().equals((Object)functionHandle)).map(x$0 -> this.sqlInvokedFunctionToMetadata((SqlInvokedFunction)x$0)).collect(MoreCollectors.onlyElement());
    }

    @Override
    protected ScalarFunctionImplementation fetchFunctionImplementationDirect(SqlFunctionHandle functionHandle) {
        return (ScalarFunctionImplementation)this.fetchFunctionsDirect(functionHandle.getFunctionId().getFunctionName()).stream().filter(function -> function.getRequiredFunctionHandle().equals((Object)functionHandle)).map(x$0 -> this.sqlInvokedFunctionToImplementation((SqlInvokedFunction)x$0)).collect(MoreCollectors.onlyElement());
    }

    private static SqlInvokedFunction copyFunction(SqlInvokedFunction function) {
        return new SqlInvokedFunction(function.getSignature().getName(), function.getParameters(), function.getSignature().getReturnType(), function.getDescription(), function.getRoutineCharacteristics(), function.getBody(), function.getVersion());
    }
}

