/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cli;

import au.com.bytecode.opencsv.CSVWriter;
import com.facebook.presto.cli.OutputPrinter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class CsvPrinter
implements OutputPrinter {
    private final List<String> fieldNames;
    private final CSVWriter writer;
    private boolean needHeader;

    public CsvPrinter(List<String> fieldNames, Writer writer, boolean header) {
        Preconditions.checkNotNull(fieldNames, (Object)"fieldNames is null");
        Preconditions.checkNotNull((Object)writer, (Object)"writer is null");
        this.fieldNames = ImmutableList.copyOf(fieldNames);
        this.writer = new CSVWriter(writer);
        this.needHeader = header;
    }

    @Override
    public void printRows(List<List<?>> rows, boolean complete) throws IOException {
        if (this.needHeader) {
            this.needHeader = false;
            this.writer.writeNext(CsvPrinter.toStrings(this.fieldNames));
        }
        for (List<?> row : rows) {
            this.writer.writeNext(CsvPrinter.toStrings(row));
            this.checkError();
        }
    }

    @Override
    public void finish() throws IOException {
        this.printRows((List<List<?>>)ImmutableList.of(), true);
        this.writer.flush();
        this.checkError();
    }

    private void checkError() throws IOException {
        if (this.writer.checkError()) {
            throw new IOException("error writing to output");
        }
    }

    private static String[] toStrings(List<?> values) {
        String[] array = new String[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            array[i] = value == null ? "" : value.toString();
        }
        return array;
    }
}

